/*
 * Decompiled with CFR 0.152.
 */
package apoc.meta;

import apoc.Description;
import apoc.result.Empty;
import apoc.result.GraphResult;
import apoc.result.StringResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Meta {
    private static final Label[] META = new Label[]{Label.label((String)"Meta")};
    @Context
    public GraphDatabaseService db;
    @Context
    public KernelTransaction kernelTx;
    static final int SAMPLE = 100;

    @Procedure
    @Description(value="apoc.meta.type(value)  - type name of a value (INTEGER,FLOAT,STRING,BOOLEAN,RELATIONSHIP,NODE,PATH,NULL,UNKNOWN,MAP,LIST)")
    public Stream<StringResult> type(@Name(value="value") Object value) {
        String typeName;
        Types type = Types.of(value);
        String string = typeName = type == Types.UNKNOWN ? value.getClass().getSimpleName() : type.name();
        if (value != null && value.getClass().isArray()) {
            typeName = typeName + "[]";
        }
        return Stream.of(new StringResult(typeName));
    }

    @Procedure
    @Description(value="apoc.meta.isType(value,type) - returns a row if type name matches none if not (INTEGER,FLOAT,STRING,BOOLEAN,RELATIONSHIP,NODE,PATH,NULL,UNKNOWN,MAP,LIST)")
    public Stream<Empty> isType(@Name(value="value") Object value, @Name(value="type") String type) {
        String typeName = Types.of(value).name();
        if (value != null && value.getClass().isArray()) {
            typeName = typeName + "[]";
        }
        return Empty.stream(type.equalsIgnoreCase(typeName));
    }

    @Procedure
    @Description(value="apoc.meta.data  - examines a subset of the graph to provide a tabular meta information")
    public Stream<MetaResult> data() {
        LinkedHashMap<String, LinkedHashMap<String, MetaResult>> labels = new LinkedHashMap<String, LinkedHashMap<String, MetaResult>>(100);
        Schema schema = this.db.schema();
        for (Label label : this.db.getAllLabels()) {
            LinkedHashMap<String, MetaResult> properties = new LinkedHashMap<String, MetaResult>(50);
            String labelName = label.name();
            labels.put(labelName, properties);
            Iterable constraints = schema.getConstraints(label);
            LinkedHashSet<String> indexed = new LinkedHashSet<String>();
            for (IndexDefinition index : schema.getIndexes(label)) {
                for (String prop : index.getPropertyKeys()) {
                    indexed.add(prop);
                }
            }
            ResourceIterator nodes = this.db.findNodes(label);
            Throwable throwable = null;
            try {
                int count = 0;
                while (nodes.hasNext() && count++ < 100) {
                    Node node = (Node)nodes.next();
                    this.addRelationships(properties, labelName, node);
                    this.addProperties(properties, labelName, constraints, indexed, node);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (nodes == null) continue;
                if (throwable != null) {
                    try {
                        nodes.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                nodes.close();
            }
        }
        return labels.values().stream().flatMap(x -> x.values().stream());
    }

    private void addProperties(Map<String, MetaResult> properties, String labelName, Iterable<ConstraintDefinition> constraints, Set<String> indexed, Node node) {
        for (String prop : node.getPropertyKeys()) {
            if (properties.containsKey(prop)) continue;
            MetaResult res = this.metaResultForProp(node, labelName, prop);
            this.addSchemaInfo(res, prop, constraints, indexed);
            properties.put(prop, res);
        }
    }

    private void addRelationships(Map<String, MetaResult> properties, String labelName, Node node) {
        for (RelationshipType type : node.getRelationshipTypes()) {
            if (properties.containsKey(type.name())) continue;
            MetaResult res = this.metaResultForRelationship(labelName, node, type);
            this.addOtherNodeInfo(node, type, res);
            properties.put(type.name(), res);
        }
    }

    private void addOtherNodeInfo(Node node, RelationshipType type, MetaResult res) {
        if (res.left == 0L) {
            return;
        }
        Iterator rels = node.getRelationships(type, Direction.OUTGOING).iterator();
        res.other = this.toStrings(((Relationship)rels.next()).getEndNode().getLabels());
    }

    private MetaResult metaResultForRelationship(String labelName, Node node, RelationshipType type) {
        int in = node.getDegree(type, Direction.INCOMING);
        int out = node.getDegree(type, Direction.OUTGOING);
        return new MetaResult(labelName, type.name()).rel(out, in);
    }

    private void addSchemaInfo(MetaResult res, String prop, Iterable<ConstraintDefinition> constraints, Set<String> indexed) {
        if (indexed.contains(prop)) {
            res.index = true;
        }
        for (ConstraintDefinition constraint : constraints) {
            for (String key : constraint.getPropertyKeys()) {
                if (!key.equals(prop)) continue;
                switch (constraint.getConstraintType()) {
                    case UNIQUENESS: {
                        res.unique = true;
                        break;
                    }
                    case NODE_PROPERTY_EXISTENCE: {
                        res.existence = true;
                        break;
                    }
                    case RELATIONSHIP_PROPERTY_EXISTENCE: {
                        res.existence = true;
                    }
                }
            }
        }
    }

    private MetaResult metaResultForProp(Node node, String labelName, String prop) {
        MetaResult res = new MetaResult(labelName, prop);
        Object value = node.getProperty(prop);
        res = res.type(Types.of(value).name());
        if (value.getClass().isArray()) {
            res.array = true;
        }
        return res;
    }

    private List<String> toStrings(Iterable<Label> labels) {
        ArrayList<String> res = new ArrayList<String>(10);
        for (Label label : labels) {
            String name = label.name();
            res.add(name);
        }
        return res;
    }

    public void sample(GraphDatabaseService db, Sampler sampler, int sampleSize) {
        for (Label label : db.getAllLabelsInUse()) {
            ResourceIterator nodes = db.findNodes(label);
            int count = 0;
            while (nodes.hasNext() && count++ < sampleSize) {
                Node node = (Node)nodes.next();
                sampler.sample(label, count, node);
                for (RelationshipType type : node.getRelationshipTypes()) {
                    this.sampleRels(sampleSize, sampler, label, count, node, type);
                }
            }
            nodes.close();
        }
    }

    private void sampleRels(int sampleSize, Sampler sampler, Label label, int count, Node node, RelationshipType type) {
        Direction direction = Direction.OUTGOING;
        int degree = node.getDegree(type, direction);
        sampler.sample(label, count, node, type, direction, degree, null);
        if (degree == 0) {
            return;
        }
        ResourceIterator relIt = ((ResourceIterable)node.getRelationships(direction, new RelationshipType[]{type})).iterator();
        int relCount = 0;
        while (relIt.hasNext() && relCount++ < sampleSize) {
            sampler.sample(label, count, node, type, direction, degree, (Relationship)relIt.next());
        }
        relIt.close();
    }

    @Procedure
    @Description(value="apoc.meta.graph - examines the full graph to create the meta-graph")
    public Stream<GraphResult> graph() {
        TreeMap<String, Node> labels = new TreeMap<String, Node>();
        HashMap<List<String>, Relationship> rels = new HashMap<List<String>, Relationship>();
        for (Relationship rel : this.db.getAllRelationships()) {
            this.addLabels(labels, rel.getStartNode());
            this.addLabels(labels, rel.getEndNode());
            this.addRel(rels, labels, rel);
        }
        return Stream.of(new GraphResult(new ArrayList<Node>(labels.values()), new ArrayList<Relationship>(rels.values())));
    }

    @Procedure
    @Description(value="apoc.meta.graphSample(sampleSize) - examines a sample graph to create the meta-graph, default sampleSize is 100")
    public Stream<GraphResult> graphSample(@Name(value="sample") Long sampleSize) {
        final TreeMap labels = new TreeMap();
        final HashMap rels = new HashMap();
        Sampler sampler = new Sampler(){

            @Override
            public void sample(Label label, int count, Node node) {
                Meta.this.mergeMetaNode(label, labels, true);
            }

            @Override
            public void sample(Label label, int count, Node node, RelationshipType type, Direction direction, int degree, Relationship rel) {
                if (rel != null) {
                    Meta.this.addRel(rels, labels, rel);
                }
            }
        };
        long sample = sampleSize == null || sampleSize < 100L ? 100L : sampleSize;
        this.sample(this.db, sampler, (int)sample);
        return Stream.of(new GraphResult(new ArrayList<Node>(labels.values()), new ArrayList<Relationship>(rels.values())));
    }

    private Node mergeMetaNode(Label label, Map<String, Node> labels, boolean increment) {
        String name = label.name();
        Node vNode = labels.get(name);
        if (vNode == null) {
            vNode = new VirtualNode(new Label[]{label, META[0]}, Collections.singletonMap("name", name), this.db);
            labels.put(name, vNode);
        }
        if (increment) {
            vNode.setProperty("count", (Object)((Integer)vNode.getProperty("count", (Object)0) + 1));
        }
        return vNode;
    }

    private void addRel(Map<List<String>, Relationship> rels, Map<String, Node> labels, Relationship rel) {
        String typeName = rel.getType().name();
        Node startNode = rel.getStartNode();
        Node endNode = rel.getEndNode();
        for (Label labelA : startNode.getLabels()) {
            Node nodeA = this.mergeMetaNode(labelA, labels, false);
            for (Label labelB : endNode.getLabels()) {
                List<String> key = Arrays.asList(labelA.name(), labelB.name(), typeName);
                Relationship vRel = rels.get(key);
                if (vRel == null) {
                    Node nodeB = this.mergeMetaNode(labelB, labels, false);
                    vRel = new VirtualRelationship(nodeA, nodeB, rel.getType()).withProperties(Collections.singletonMap("type", typeName));
                    rels.put(key, vRel);
                }
                vRel.setProperty("count", (Object)((Integer)vRel.getProperty("count", (Object)0) + 1));
            }
        }
    }

    private void addLabels(Map<String, Node> labels, Node node) {
        for (Label label : node.getLabels()) {
            this.mergeMetaNode(label, labels, true);
        }
    }

    static class NodeInfo {
        final Set<String> labels = new HashSet<String>();
        final Set<String> properties = new HashSet<String>();
        long count;
        long minDegree;
        long maxDegree;
        long sumDegree;

        NodeInfo() {
        }

        private void add(Node node) {
            ++this.count;
            int degree = node.getDegree();
            this.sumDegree += (long)degree;
            if ((long)degree > this.maxDegree) {
                this.maxDegree = degree;
            }
            if ((long)degree < this.minDegree) {
                this.minDegree = degree;
            }
            for (Label label : node.getLabels()) {
                this.labels.add(label.name());
            }
            for (String key : node.getPropertyKeys()) {
                this.properties.add(key);
            }
        }

        Map<String, Object> toMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("labels", this.labels.toArray());
            map.put("properties", this.properties.toArray());
            map.put("count", this.count);
            map.put("minDegree", this.minDegree);
            map.put("maxDegree", this.maxDegree);
            map.put("avgDegree", this.sumDegree / this.count);
            return map;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof NodeInfo && this.labels.equals(((NodeInfo)o).labels);
        }

        public int hashCode() {
            return this.labels.hashCode();
        }
    }

    static class RelInfo {
        final Set<String> properties = new HashSet<String>();
        final NodeInfo from;
        final NodeInfo to;
        final String type;
        int count;

        public RelInfo(NodeInfo from, NodeInfo to, String type) {
            this.from = from;
            this.to = to;
            this.type = type;
        }

        public void add(Relationship relationship) {
            for (String key : relationship.getPropertyKeys()) {
                this.properties.add(key);
            }
            ++this.count;
        }
    }

    static interface Sampler {
        public void sample(Label var1, int var2, Node var3);

        public void sample(Label var1, int var2, Node var3, RelationshipType var4, Direction var5, int var6, Relationship var7);
    }

    public static class MetaResult {
        public String label;
        public String property;
        public boolean unique;
        public boolean index;
        public boolean existence;
        public String type;
        public boolean array;
        public List<Object> sample;
        public long left;
        public long right;
        public List<String> other;

        public MetaResult(String label, String name) {
            this.label = label;
            this.property = name;
        }

        public MetaResult rel(int out, int in) {
            this.type = Types.RELATIONSHIP.name();
            if (out > 1) {
                this.array = true;
            }
            this.left = out;
            this.right = in;
            return this;
        }

        public MetaResult other(List<String> labels) {
            this.other = labels;
            return this;
        }

        public MetaResult type(String type) {
            this.type = type;
            return this;
        }

        public MetaResult array(boolean array) {
            this.array = array;
            return this;
        }
    }

    public static enum Types {
        INTEGER,
        FLOAT,
        STRING,
        BOOLEAN,
        RELATIONSHIP,
        NODE,
        PATH,
        NULL,
        UNKNOWN,
        MAP,
        LIST;


        public static Types of(Object value) {
            if (value == null) {
                return NULL;
            }
            Class<?> type = value.getClass();
            if (type.isArray()) {
                type = type.getComponentType();
            }
            if (Number.class.isAssignableFrom(type)) {
                return Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) ? FLOAT : INTEGER;
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (value instanceof String) {
                return STRING;
            }
            if (Map.class.isAssignableFrom(type)) {
                return MAP;
            }
            if (Node.class.isAssignableFrom(type)) {
                return NODE;
            }
            if (Relationship.class.isAssignableFrom(type)) {
                return RELATIONSHIP;
            }
            if (Path.class.isAssignableFrom(type)) {
                return PATH;
            }
            if (Iterable.class.isAssignableFrom(type)) {
                return LIST;
            }
            return UNKNOWN;
        }
    }
}

