/*
 * Decompiled with CFR 0.152.
 */
package apoc.map;

import apoc.Description;
import apoc.result.MapResult;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.PerformsWrites;
import org.neo4j.procedure.Procedure;

public class MapUtil {
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.map.fromPairs([[key,value],[key2,value2],...])")
    public Stream<MapResult> fromPairs(@Name(value="pairs") List<List<Object>> pairs) {
        return Stream.of(new MapResult(this.mapFromPairs(pairs)));
    }

    private Map<String, Object> mapFromPairs(@Name(value="pairs") List<List<Object>> pairs) {
        if (pairs.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(pairs.size());
        for (List<Object> pair : pairs) {
            Object key;
            if (pair.isEmpty() || (key = pair.get(0)) == null) continue;
            Object value = pair.size() >= 2 ? pair.get(1) : null;
            map.put(key.toString(), value);
        }
        return map;
    }

    @Procedure
    @Description(value="apoc.map.fromLists([keys],[values])")
    public Stream<MapResult> fromLists(@Name(value="keys") List<String> keys, @Name(value="values") List<Object> values) {
        return Stream.of(new MapResult(this.mapFromLists(keys, values)));
    }

    private Map<String, Object> mapFromLists(@Name(value="keys") List<String> keys, @Name(value="values") List<Object> values) {
        assert (keys.size() == values.size());
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        if (keys.size() == 1) {
            return Collections.singletonMap(keys.get(0), values.get(0));
        }
        ListIterator<Object> it = values.listIterator();
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(keys.size());
        for (String key : keys) {
            res.put(key, it.next());
        }
        return res;
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.map.setKey(map,key,value)")
    public Stream<MapResult> setKey(@Name(value="map") Map<String, Object> map, @Name(value="key") String key, @Name(value="value") Object value) {
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(map);
        res.put(key, value);
        return Stream.of(new MapResult(res));
    }
}

