/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.Description;
import apoc.result.MapResult;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Xml {
    public static final XMLInputFactory FACTORY = XMLInputFactory.newFactory();
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.load.xml('http://example.com/test.xml') YIELD value as doc CREATE (p:Person) SET p.name = doc.name load from XML URL (e.g. web-api) to import XML as single nested map with attributes and _type, _text and _childrenx fields.")
    public Stream<MapResult> xml(@Name(value="url") String url) {
        try {
            URLConnection urlConnection = new URL(url).openConnection();
            XMLStreamReader reader = FACTORY.createXMLStreamReader(urlConnection.getInputStream());
            if (reader.nextTag() == 1) {
                return Stream.of(new MapResult(this.handleElement(reader)));
            }
            throw new RuntimeException("Can't read url " + url + " as XML");
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException("Can't read url " + url + " as XML", e);
        }
    }

    private Map<String, Object> handleElement(XMLStreamReader reader) throws XMLStreamException {
        LinkedHashMap<String, Object> row = null;
        String element = null;
        if (reader.isStartElement()) {
            int attributes = reader.getAttributeCount();
            row = new LinkedHashMap<String, Object>(attributes + 3);
            element = reader.getLocalName();
            row.put("_type", element);
            for (int a = 0; a < attributes; ++a) {
                row.put(reader.getAttributeLocalName(a), reader.getAttributeValue(a));
            }
            this.next(reader);
            if (reader.hasText()) {
                row.put("_text", reader.getText().trim());
                this.next(reader);
            }
            if (reader.isStartElement()) {
                ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>(100);
                do {
                    Map<String, Object> child;
                    if ((child = this.handleElement(reader)) == null || child.isEmpty()) continue;
                    children.add(child);
                } while (this.next(reader) == 1);
                if (!children.isEmpty()) {
                    row.put("_children", children);
                }
            }
            if (reader.isEndElement() || reader.getEventType() == 8) {
                return row;
            }
        }
        throw new IllegalStateException("Incorrect end-element state " + reader.getEventType() + " after " + element);
    }

    private int next(XMLStreamReader reader) throws XMLStreamException {
        reader.next();
        while (reader.isWhiteSpace()) {
            reader.next();
        }
        return reader.getEventType();
    }
}

