/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.Description;
import apoc.result.RowResult;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Jdbc {
    @Procedure
    @Description(value="apoc.load.driver('org.apache.derby.jdbc.EmbeddedDriver') register JDBC driver of source database")
    public void driver(@Name(value="driverClass") String driverClass) {
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load driver class " + driverClass + " " + e.getMessage());
        }
    }

    @Procedure
    @Description(value="apoc.load.jdbc('jdbc:derby:derbyDB','PERSON' || 'SELECT * FROM PERSON WHERE AGE > 18') YIELD row CREATE (:Person {name:row.name}) load from relational database, either a full table or a sql statement")
    public Stream<RowResult> jdbc(@Name(value="jdbc") String url, @Name(value="tableOrSql") String tableOrSelect) {
        String query = tableOrSelect.indexOf(32) == -1 ? "SELECT * FROM " + tableOrSelect : tableOrSelect;
        try {
            Statement stmt = DriverManager.getConnection(url).createStatement();
            ResultSet rs = stmt.executeQuery(query);
            ResultSetIterator supplier = new ResultSetIterator(rs);
            Spliterator<Map<String, Object>> spliterator = Spliterators.spliteratorUnknownSize(supplier, 16);
            return StreamSupport.stream(spliterator, false).map(RowResult::new);
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot execute SQL statement " + query, e);
        }
    }

    private static class ResultSetIterator
    implements Iterator<Map<String, Object>> {
        private final ResultSet rs;
        private final String[] columns;
        private Map<String, Object> map;

        public ResultSetIterator(ResultSet rs) throws SQLException {
            this.rs = rs;
            this.columns = this.getMetaData(rs);
            this.map = this.get();
        }

        private String[] getMetaData(ResultSet rs) throws SQLException {
            ResultSetMetaData meta = rs.getMetaData();
            int cols = meta.getColumnCount();
            String[] columns = new String[cols + 1];
            for (int col = 1; col <= cols; ++col) {
                columns[col] = meta.getColumnName(col);
            }
            return columns;
        }

        @Override
        public boolean hasNext() {
            return this.map != null;
        }

        @Override
        public Map<String, Object> next() {
            Map<String, Object> current = this.map;
            this.map = this.get();
            return current;
        }

        public Map<String, Object> get() {
            try {
                if (this.handleEndOfResults()) {
                    return null;
                }
                LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>(this.columns.length);
                for (int col = 1; col < this.columns.length; ++col) {
                    row.put(this.columns[col], this.rs.getObject(col));
                }
                return row;
            }
            catch (SQLException e) {
                throw new RuntimeException("Cannot execute read result-set.", e);
            }
        }

        private boolean handleEndOfResults() throws SQLException {
            if (this.rs.isClosed()) {
                return true;
            }
            if (!this.rs.next()) {
                if (!this.rs.isClosed()) {
                    this.rs.getStatement().close();
                }
                return true;
            }
            return false;
        }
    }
}

