/*
 * Decompiled with CFR 0.152.
 */
package apoc.index;

import apoc.Description;
import apoc.result.WeightedNodeResult;
import apoc.result.WeightedRelationshipResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.index.impl.lucene.legacy.LuceneIndexImplementation;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.PerformsWrites;
import org.neo4j.procedure.Procedure;

public class FulltextIndex {
    private static final Map<String, String> FULL_TEXT = LuceneIndexImplementation.FULLTEXT_CONFIG;
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;

    @Description(value="apoc.index.nodes('Label','prop:value*') YIELD node - lucene query on node index with the given label name")
    @Procedure
    @PerformsWrites
    public Stream<WeightedNodeResult> nodes(@Name(value="label") String label, @Name(value="query") String query) {
        if (!this.db.index().existsForNodes(label)) {
            return Stream.empty();
        }
        IndexHits hits = this.db.index().forNodes(label).query((Object)query);
        return this.toWeightedNodeResult((IndexHits<Node>)hits).stream();
    }

    private List<WeightedNodeResult> toWeightedNodeResult(IndexHits<Node> hits) {
        ArrayList<WeightedNodeResult> results = new ArrayList<WeightedNodeResult>(hits.size());
        while (hits.hasNext()) {
            results.add(new WeightedNodeResult((Node)hits.next(), hits.currentScore()));
        }
        return results;
    }

    private List<WeightedRelationshipResult> toWeightedRelationshipResult(IndexHits<Relationship> hits) {
        ArrayList<WeightedRelationshipResult> results = new ArrayList<WeightedRelationshipResult>(hits.size());
        while (hits.hasNext()) {
            results.add(new WeightedRelationshipResult((Relationship)hits.next(), hits.currentScore()));
        }
        return results;
    }

    @Description(value="apoc.index.relationships('TYPE','prop:value*') YIELD rel - lucene query on relationship index with the given type name")
    @Procedure
    @PerformsWrites
    public Stream<WeightedRelationshipResult> relationships(@Name(value="type") String type, @Name(value="query") String query) {
        if (!this.db.index().existsForRelationships(type)) {
            return Stream.empty();
        }
        return this.toWeightedRelationshipResult((IndexHits<Relationship>)this.db.index().forRelationships(type).query((Object)query)).stream();
    }

    @Description(value="apoc.index.between(node1,'TYPE',node2,'prop:value*') YIELD rel - lucene query on relationship index with the given type name bound by either or both sides (each node parameter can be null)")
    @Procedure
    @PerformsWrites
    public Stream<WeightedRelationshipResult> between(@Name(value="from") Node from, @Name(value="type") String type, @Name(value="to") Node to, @Name(value="query") String query) {
        if (!this.db.index().existsForRelationships(type)) {
            return Stream.empty();
        }
        return this.toWeightedRelationshipResult((IndexHits<Relationship>)this.db.index().forRelationships(type).query((Object)query, from, to)).stream();
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.index.out(node,'TYPE','prop:value*') YIELD node - lucene query on relationship index with the given type name for *outgoing* relationship of the given node, *returns end-nodes*")
    public Stream<WeightedNodeResult> out(@Name(value="from") Node from, @Name(value="type") String type, @Name(value="query") String query) {
        if (!this.db.index().existsForRelationships(type)) {
            return Stream.empty();
        }
        IndexHits hits = this.db.index().forRelationships(type).query((Object)query, from, null);
        ArrayList<WeightedNodeResult> results = new ArrayList<WeightedNodeResult>(hits.size());
        while (hits.hasNext()) {
            results.add(new WeightedNodeResult(((Relationship)hits.next()).getEndNode(), hits.currentScore()));
        }
        return results.stream();
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.index.in(node,'TYPE','prop:value*') YIELD node lucene query on relationship index with the given type name for *incoming* relationship of the given node, *returns start-nodes*")
    public Stream<WeightedNodeResult> in(@Name(value="to") Node to, @Name(value="type") String type, @Name(value="query") String query) {
        if (!this.db.index().existsForRelationships(type)) {
            return Stream.empty();
        }
        IndexHits hits = this.db.index().forRelationships(type).query((Object)query, null, to);
        ArrayList<WeightedNodeResult> results = new ArrayList<WeightedNodeResult>(hits.size());
        while (hits.hasNext()) {
            results.add(new WeightedNodeResult(((Relationship)hits.next()).getStartNode(), hits.currentScore()));
        }
        return results.stream();
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.index.addNode(node,['prop1',...]) add node to an index for each label it has")
    public void addNode(@Name(value="node") Node node, @Name(value="properties") List<String> propKeys) {
        for (Label label : node.getLabels()) {
            this.addNodeByLabel(label.name(), node, propKeys);
        }
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.index.addNodeByLabel(node,'Label',['prop1',...]) add node to an index for the given label")
    public void addNodeByLabel(@Name(value="label") String label, @Name(value="node") Node node, @Name(value="properties") List<String> propKeys) {
        Index index = this.db.index().forNodes(label, FULL_TEXT);
        this.indexContainer(node, propKeys, index);
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.index.addRelationship(rel,['prop1',...]) add relationship to an index for its type")
    public void addRelationship(@Name(value="relationship") Relationship rel, @Name(value="properties") List<String> propKeys) {
        String indexName = rel.getType().name();
        RelationshipIndex index = this.db.index().forRelationships(indexName, FULL_TEXT);
        this.indexContainer((PropertyContainer)rel, propKeys, (Index)index);
    }

    private <T extends PropertyContainer> void indexContainer(T pc, @Name(value="properties") List<String> propKeys, Index<T> index) {
        index.remove(pc);
        for (String key : propKeys) {
            Object value = pc.getProperty(key, null);
            if (value == null) continue;
            index.add(pc, key, value);
        }
    }
}

