/*
 * Decompiled with CFR 0.152.
 */
package apoc.help;

import apoc.help.HelpResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Stream;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class HelpScanner {
    static final Map<String, HelpResult> procedures = new TreeMap<String, HelpResult>();
    public static final String JAR_NAME_PART = "apoc";

    void handleClass(InputStream in) throws IOException {
        MyClassVisitor cv = new MyClassVisitor();
        new ClassReader(in).accept((ClassVisitor)cv, 0);
    }

    public static Stream<HelpResult> find(String name) {
        if (name == null) {
            return Stream.empty();
        }
        return procedures.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(name) || ((String)e.getKey()).endsWith(name)).map(Map.Entry::getValue);
    }

    List<URL> getRootUrls() {
        ArrayList<URL> result = new ArrayList<URL>();
        for (ClassLoader cl = Thread.currentThread().getContextClassLoader(); cl != null; cl = cl.getParent()) {
            if (!(cl instanceof URLClassLoader)) continue;
            URL[] urls = ((URLClassLoader)cl).getURLs();
            result.addAll(Arrays.asList(urls));
        }
        return result;
    }

    void scanAll() {
        try {
            for (URL url : this.getRootUrls()) {
                File f = new File(url.getPath());
                if (f.isDirectory()) {
                    this.visitFile(f);
                    continue;
                }
                this.visitJar(url);
            }
        }
        catch (Exception e) {
            System.err.println("APOC: Error scanning procedures " + e.getMessage());
        }
    }

    void visitFile(File f) throws IOException {
        block29: {
            block28: {
                if (!f.isDirectory()) break block28;
                File[] children = f.listFiles();
                if (children == null) break block29;
                for (File child : children) {
                    this.visitFile(child);
                }
                break block29;
            }
            if (f.getName().endsWith(".class")) {
                try (FileInputStream in = new FileInputStream(f);){
                    this.handleClass(in);
                }
            } else {
                String fileName = f.getName();
                if (fileName.endsWith(".jar") && fileName.contains(JAR_NAME_PART)) {
                    try (FileInputStream in = new FileInputStream(f);){
                        this.visitJar(in);
                    }
                }
            }
        }
    }

    void visitJar(URL url) throws IOException {
        if (!url.getPath().contains(JAR_NAME_PART)) {
            return;
        }
        try (InputStream urlIn = url.openStream();){
            this.visitJar(urlIn);
        }
    }

    private void visitJar(InputStream in) throws IOException {
        try (JarInputStream jarIn = new JarInputStream(in);){
            JarEntry entry;
            while ((entry = jarIn.getNextJarEntry()) != null) {
                if (!entry.getName().endsWith(".class")) continue;
                this.handleClass(jarIn);
            }
        }
    }

    static {
        new HelpScanner().scanAll();
    }

    class MyClassVisitor
    extends ClassVisitor {
        public String className;
        public String packageName;

        MyClassVisitor() {
            super(327680);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name.replace('/', '.');
            this.packageName = this.className.substring(0, this.className.lastIndexOf(46));
        }

        public MethodVisitor visitMethod(int access, final String name, String desc, String signature, String[] exceptions) {
            return new MethodVisitor(this.api){
                String descriptionText;
                boolean isProcedure;
                boolean performsWrites;
                String procedureName;
                {
                    super(x0);
                    this.procedureName = MyClassVisitor.this.packageName + "." + name;
                }

                public AnnotationVisitor visitAnnotation(String annotation, boolean b) {
                    switch (annotation) {
                        case "Lapoc/Description;": {
                            return new AnnotationVisitor(this.api){

                                public void visit(String name, Object value) {
                                    if (Objects.equals(name, "value") && value != null) {
                                        descriptionText = value.toString();
                                    }
                                }
                            };
                        }
                        case "Lorg/neo4j/procedure/Procedure;": {
                            this.isProcedure = true;
                            return new AnnotationVisitor(this.api){

                                public void visit(String name, Object value) {
                                    if (Objects.equals(name, "value") && value != null) {
                                        procedureName = value.toString();
                                    }
                                }
                            };
                        }
                        case "Lorg/neo4j/procedure/PerformsWrites;": {
                            this.performsWrites = true;
                        }
                    }
                    return null;
                }

                public void visitEnd() {
                    if (this.isProcedure) {
                        System.err.printf("APOC: %s declares procedure %s writes %s desc %s%n", MyClassVisitor.this.className, this.procedureName, this.performsWrites, this.descriptionText);
                        procedures.put(this.procedureName, new HelpResult(this.procedureName, this.descriptionText, this.performsWrites));
                    }
                }
            };
        }
    }
}

