/*
 * Decompiled with CFR 0.152.
 */
package apoc.date;

import apoc.Description;
import apoc.result.LongResult;
import apoc.result.MapResult;
import apoc.result.StringResult;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Date {
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final int MILLIS_IN_SECOND = 1000;
    private static final String UTC_ZONE_ID = "UTC";
    private static final List<TemporalQuery<Consumer<Map<String, Object>>>> DT_FIELDS_SELECTORS = Arrays.asList(Date.temporalQuery(ChronoField.YEAR), Date.temporalQuery(ChronoField.MONTH_OF_YEAR), Date.temporalQuery(ChronoField.DAY_OF_MONTH), Date.temporalQuery(ChronoField.HOUR_OF_DAY), Date.temporalQuery(ChronoField.MINUTE_OF_HOUR), Date.temporalQuery(ChronoField.SECOND_OF_MINUTE), temporal -> map -> Optional.ofNullable(TemporalQueries.zoneId().queryFrom(temporal)).ifPresent(zoneId -> map.put("zoneid", zoneId.getId())));

    @Procedure
    @Description(value="apoc.date.fields('2012-12-23 13:10:50') - create structured map representation of date with entries for year,month,day,hour,minute,second,zoneid")
    public Stream<MapResult> fields(@Name(value="date") String date) {
        return this.fieldsFormatted(date, null);
    }

    @Procedure
    @Description(value="apoc.date.fieldsFormatted('2012-12-23','yyyy-MM-dd') - create structured map representation of date parsed with the given format with entries for year,month,day,hour,minute,second,zoneid")
    public Stream<MapResult> fieldsFormatted(@Name(value="date") String date, @Name(value="pattern") String pattern) {
        if (date == null) {
            return Stream.of(MapResult.empty());
        }
        DateTimeFormatter fmt = Date.getDateTimeFormatter(pattern);
        TemporalAccessor temporal = fmt.parse(date);
        HashMap selectFields = new HashMap();
        for (TemporalQuery<Consumer<Map<String, Object>>> query : DT_FIELDS_SELECTORS) {
            query.queryFrom(temporal).accept(selectFields);
        }
        return Stream.of(new MapResult(selectFields));
    }

    @Procedure
    @Description(value="apoc.date.fromSeconds(12345) get string representation of date corresponding to given Unix time (in seconds)")
    public Stream<StringResult> fromSeconds(@Name(value="seconds") long unixtime) {
        return this.fromSecondsFormatted(unixtime, null);
    }

    @Procedure
    @Description(value="apoc.date.fromSecondsFormatted(12345, 'yyyy/MM/dd HH/mm/ss') the same as previous, but accepts custom datetime format")
    public Stream<StringResult> fromSecondsFormatted(@Name(value="seconds") long unixtime, @Name(value="pattern") String pattern) {
        return this.fromMillisFormatted(TimeUnit.SECONDS.toMillis(unixtime), pattern);
    }

    @Procedure
    @Description(value="apoc.date.fromMillis(12345) get string representation of date corresponding to given time in milliseconds")
    public Stream<StringResult> fromMillis(@Name(value="millis") long millis) {
        return this.fromMillisFormatted(millis, null);
    }

    @Procedure
    @Description(value="apoc.date.fromMillisFormatted(12345, 'yyyy/MM/dd HH/mm/ss') the same as previous, but accepts custom datetime format")
    public Stream<StringResult> fromMillisFormatted(@Name(value="millis") long millis, @Name(value="pattern") String pattern) {
        if (millis < 0L) {
            throw new IllegalArgumentException("The time argument should be >= 0, got: " + millis);
        }
        return Stream.of(new StringResult(Date.getFormat(pattern).format(new java.util.Date(millis))));
    }

    @Procedure
    @Description(value="apoc.date.toSeconds('2015-03-25 03:15:59') get Unix time equivalent of given date (in seconds)")
    public Stream<LongResult> toSeconds(@Name(value="date") String dateField) {
        return this.toSecondsFormatted(dateField, null);
    }

    @Procedure
    @Description(value="apoc.date.toMillis('2015-03-25 03:15:59') get Unix time equivalent of given date (in milliseconds)")
    public Stream<LongResult> toMillis(@Name(value="date") String dateField) {
        return this.toMillisFormatted(dateField, null);
    }

    @Procedure
    @Description(value="apoc.date.toSecondsFormatted('2015/03/25 03-15-59', 'yyyy/MM/dd HH/mm/ss') same as previous, but accepts custom datetime format")
    public Stream<LongResult> toSecondsFormatted(@Name(value="date") String dateField, @Name(value="pattern") String pattern) {
        return this.toMillisFormatted(dateField, pattern).map(l -> l.value != null ? new LongResult(TimeUnit.MILLISECONDS.toSeconds(l.value)) : l);
    }

    @Procedure
    @Description(value="apoc.date.toMillisFormatted('2015/03/25 03-15-59', 'yyyy/MM/dd HH/mm/ss') same as previous, but accepts custom datetime format")
    public Stream<LongResult> toMillisFormatted(@Name(value="date") String dateField, @Name(value="pattern") String pattern) {
        if (dateField == null) {
            return Stream.of(LongResult.NULL);
        }
        DateFormat format = Date.getFormat(pattern);
        java.util.Date parse = Date.parseOrThrow(dateField, format);
        return Stream.of(new LongResult(parse.getTime()));
    }

    private static DateFormat getFormat(String pattern) {
        String actualPattern = Date.getPattern(pattern);
        SimpleDateFormat format = new SimpleDateFormat(actualPattern);
        if (!Date.containsTimeZonePattern(actualPattern)) {
            format.setTimeZone(TimeZone.getTimeZone(UTC_ZONE_ID));
        }
        return format;
    }

    private static DateTimeFormatter getDateTimeFormatter(String pattern) {
        String actualPattern = Date.getPattern(pattern);
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(actualPattern);
        if (!Date.containsTimeZonePattern(actualPattern)) {
            return fmt.withZone(ZoneId.of(UTC_ZONE_ID));
        }
        return fmt;
    }

    private static java.util.Date parseOrThrow(String date, DateFormat format) {
        java.util.Date parsed;
        try {
            parsed = format.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        return parsed;
    }

    private static boolean containsTimeZonePattern(String pattern) {
        return pattern.matches("[XZz]{1,3}");
    }

    private static String getPattern(String pattern) {
        return pattern == null ? DEFAULT_FORMAT : pattern;
    }

    private static TemporalQuery<Consumer<Map<String, Object>>> temporalQuery(ChronoField field) {
        return temporal -> map -> {
            if (field.isSupportedBy(temporal)) {
                map.put(field.getBaseUnit().toString().toLowerCase(), field.getFrom(temporal));
            }
        };
    }
}

