/*
 * Decompiled with CFR 0.152.
 */
package apoc.create;

import apoc.Description;
import apoc.result.NodeResult;
import apoc.result.RelationshipResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualPathResult;
import apoc.result.VirtualRelationship;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.PerformsWrites;
import org.neo4j.procedure.Procedure;

public class Create {
    private static final Label[] NO_LABELS = new Label[0];
    @Context
    public GraphDatabaseService db;

    @Procedure
    @PerformsWrites
    @Description(value="apoc.create.node(['Label'], {key:value,...}) - create node with dynamic labels")
    public Stream<NodeResult> node(@Name(value="label") List<String> labelNames, @Name(value="props") Map<String, Object> props) {
        return Stream.of(new NodeResult(this.setProperties(this.db.createNode(this.labels(labelNames)), props)));
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.create.nodes(['Label'], [{key:value,...}]) create multiple nodes with dynamic labels")
    public Stream<NodeResult> nodes(@Name(value="label") List<String> labelNames, @Name(value="props") List<Map<String, Object>> props) {
        Label[] labels = this.labels(labelNames);
        return props.stream().map(p -> new NodeResult(this.setProperties((PropertyContainer)this.db.createNode(labels), (Map<String, Object>)p)));
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.create.relationship(person1,'KNOWS',{key:value,...}, person2) create relationship with dynamic rel-type")
    public Stream<RelationshipResult> relationship(@Name(value="from") Node from, @Name(value="relType") String relType, @Name(value="props") Map<String, Object> props, @Name(value="to") Node to) {
        return Stream.of(new RelationshipResult(this.setProperties(from.createRelationshipTo(to, RelationshipType.withName((String)relType)), props)));
    }

    @Procedure
    @Description(value="apoc.create.vNode(['Label'], {key:value,...}) returns a virtual node")
    public Stream<NodeResult> vNode(@Name(value="label") List<String> labelNames, @Name(value="props") Map<String, Object> props) {
        Label[] labels = this.labels(labelNames);
        return Stream.of(new NodeResult(new VirtualNode(labels, props, this.db)));
    }

    @Procedure
    @Description(value="apoc.create.vNodes(['Label'], [{key:value,...}]) returns virtual nodes")
    public Stream<NodeResult> vNodes(@Name(value="label") List<String> labelNames, @Name(value="props") List<Map<String, Object>> props) {
        Label[] labels = this.labels(labelNames);
        return props.stream().map(p -> new NodeResult(new VirtualNode(labels, (Map<String, Object>)p, this.db)));
    }

    @Procedure
    @Description(value="apoc.create.vRelationship(nodeFrom,'KNOWS',{key:value,...}, nodeTo) returns a virtual relationship")
    public Stream<RelationshipResult> vRelationship(@Name(value="from") Node from, @Name(value="relType") String relType, @Name(value="props") Map<String, Object> props, @Name(value="to") Node to) {
        RelationshipType type = RelationshipType.withName((String)relType);
        return Stream.of(new RelationshipResult(new VirtualRelationship(from, to, type).withProperties(props)));
    }

    @Procedure
    @Description(value="apoc.create.vPattern({_labels:['LabelA'],key:value},'KNOWS',{key:value,...}, {_labels:['LabelB'],key:value}) returns a virtual pattern")
    public Stream<VirtualPathResult> vPattern(@Name(value="from") Map<String, Object> n, @Name(value="relType") String relType, @Name(value="props") Map<String, Object> props, @Name(value="to") Map<String, Object> m) {
        n = new LinkedHashMap<String, Object>(n);
        m = new LinkedHashMap<String, Object>(m);
        RelationshipType type = RelationshipType.withName((String)relType);
        VirtualNode from = new VirtualNode(this.labels(n.remove("_labels")), n, this.db);
        VirtualNode to = new VirtualNode(this.labels(m.remove("_labels")), m, this.db);
        Relationship rel = new VirtualRelationship(from, to, RelationshipType.withName((String)relType)).withProperties(props);
        return Stream.of(new VirtualPathResult(from, rel, to));
    }

    @Procedure
    @Description(value="apoc.create.vPatternFull(['LabelA'],{key:value},'KNOWS',{key:value,...},['LabelB'],{key:value}) returns a virtual pattern")
    public Stream<VirtualPathResult> vPatternFull(@Name(value="labelsN") List<String> labelsN, @Name(value="n") Map<String, Object> n, @Name(value="relType") String relType, @Name(value="props") Map<String, Object> props, @Name(value="labelsM") List<String> labelsM, @Name(value="m") Map<String, Object> m) {
        RelationshipType type = RelationshipType.withName((String)relType);
        VirtualNode from = new VirtualNode(this.labels(labelsN), n, this.db);
        VirtualNode to = new VirtualNode(this.labels(labelsM), m, this.db);
        Relationship rel = new VirtualRelationship(from, to, type).withProperties(props);
        return Stream.of(new VirtualPathResult(from, rel, to));
    }

    @Description(value="TODO apoc.create.vGraph([nodes, {_labels:[],... prop:value,...}], [rels,{_from:keyValueFrom,_to:{_label:,_key:,_value:value}, _type:'KNOWS', prop:value,...}],['pk1','Label2:pk2'])")
    public Stream<VirtualPathResult> vGraph() {
        return Stream.empty();
    }

    private <T extends PropertyContainer> T setProperties(T pc, Map<String, Object> p) {
        if (p == null) {
            return pc;
        }
        for (Map.Entry<String, Object> entry : p.entrySet()) {
            pc.setProperty(entry.getKey(), entry.getValue());
        }
        return pc;
    }

    private Label[] labels(Object labelNames) {
        if (labelNames == null) {
            return NO_LABELS;
        }
        if (labelNames instanceof List) {
            List names = (List)labelNames;
            Label[] labels = new Label[names.size()];
            int i = 0;
            for (Object l : names) {
                if (l == null) continue;
                labels[i++] = Label.label((String)l.toString());
            }
            if (i <= labels.length) {
                return Arrays.copyOf(labels, i);
            }
            return labels;
        }
        return new Label[]{Label.label((String)labelNames.toString())};
    }

    private RelationshipType type(Object type) {
        if (type == null) {
            throw new RuntimeException("No relationship-type provided");
        }
        return RelationshipType.withName((String)type.toString());
    }
}

