/*
 * Decompiled with CFR 0.152.
 */
package apoc.convert;

import apoc.Description;
import apoc.result.ListResult;
import apoc.result.MapResult;
import apoc.result.ObjectResult;
import apoc.result.StringResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.codehaus.jackson.map.ObjectMapper;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.PerformsWrites;
import org.neo4j.procedure.Procedure;

public class Json {
    public static ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.convert.toJson([1,2,3]) or toJson({a:42,b:\"foo\",c:[1,2,3]})")
    public Stream<StringResult> toJson(@Name(value="value") Object value) {
        try {
            return Stream.of(new StringResult(OBJECT_MAPPER.writeValueAsString(value)));
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert " + value + " to json", e);
        }
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.json.setJsonProperty(node,key,complexValue) - sets value serialized to JSON as property with the given name on the node")
    public void setJsonProperty(@Name(value="node") Node node, @Name(value="key") String key, @Name(value="value") Object value) {
        try {
            node.setProperty(key, (Object)OBJECT_MAPPER.writeValueAsString(value));
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert " + value + " to json", e);
        }
    }

    @Procedure
    @Description(value="apoc.json.getJsonProperty(node,key) - converts serialized JSON in property to structure again")
    public Stream<ObjectResult> getJsonProperty(@Name(value="node") Node node, @Name(value="key") String key) {
        String value = (String)node.getProperty(key, null);
        try {
            return Stream.of(new ObjectResult(OBJECT_MAPPER.readValue(value, Object.class)));
        }
        catch (IOException e) {
            throw new RuntimeException("Can't convert " + value + " to json", e);
        }
    }

    @Procedure
    @Description(value="apoc.convert.fromJsonMap('{\"a\":42,\"b\":\"foo\",\"c\":[1,2,3]}')")
    public Stream<MapResult> fromJsonMap(@Name(value="map") String value) {
        try {
            return Stream.of(new MapResult((Map)OBJECT_MAPPER.readValue(value, Map.class)));
        }
        catch (IOException e) {
            throw new RuntimeException("Can't deserialize to Map:\n" + value, e);
        }
    }

    @Procedure
    @Description(value="apoc.convert.fromJsonList('[1,2,3]')")
    public Stream<ListResult> fromJsonList(@Name(value="list") String value) {
        try {
            return Stream.of(new ListResult((List)OBJECT_MAPPER.readValue(value, List.class)));
        }
        catch (IOException e) {
            throw new RuntimeException("Can't deserialize to List:\n" + value, e);
        }
    }
}

