/*
 * Decompiled with CFR 0.152.
 */
package apoc.coll;

import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;

class SetBackedList
extends AbstractSequentialList {
    private final Set set;

    public SetBackedList(Set set) {
        this.set = set;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            Iterator it;
            Object current;
            int idx;
            {
                this.it = SetBackedList.this.set.iterator();
                this.current = null;
                this.idx = 0;
                this.moveTo(index);
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Object next() {
                ++this.idx;
                this.current = this.it.next();
                return this.current;
            }

            @Override
            public boolean hasPrevious() {
                return this.idx > 0;
            }

            public Object previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                Object tmp = this.current;
                this.moveTo(this.idx - 1);
                return tmp;
            }

            private void moveTo(int pos) {
                Iterator it2 = SetBackedList.this.set.iterator();
                Object value = null;
                int i = 0;
                while (i++ < pos) {
                    value = it2.next();
                }
                this.it = it2;
                this.idx = pos;
                this.current = value;
            }

            @Override
            public int nextIndex() {
                return this.idx;
            }

            @Override
            public int previousIndex() {
                return this.idx - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            public void set(Object o) {
                throw new UnsupportedOperationException("set");
            }

            public void add(Object o) {
                throw new UnsupportedOperationException("add");
            }
        };
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }
}

