/*
 * Decompiled with CFR 0.152.
 */
package apoc.coll;

import apoc.Description;
import apoc.coll.SetBackedList;
import apoc.result.DoubleResult;
import apoc.result.Empty;
import apoc.result.ListResult;
import apoc.result.LongResult;
import apoc.result.ObjectResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Coll {
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.coll.zipToRows(list1,list2) - creates pairs like zip but emits one row per pair")
    public Stream<ListResult> zipToRows(@Name(value="list1") List<Object> list1, @Name(value="list2") List<Object> list2) {
        if (list1.isEmpty()) {
            return Stream.empty();
        }
        ListIterator<Object> it = list2.listIterator();
        return list1.stream().map(e -> new ListResult(Arrays.asList(e, it.hasNext() ? it.next() : null)));
    }

    @Procedure
    @Description(value="apoc.coll.zip([list1],[list2])")
    public Stream<ListResult> zip(@Name(value="list1") List<Object> list1, @Name(value="list2") List<Object> list2) {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(list1.size());
        ListIterator<Object> it = list2.listIterator();
        for (Object o1 : list1) {
            result.add(Arrays.asList(o1, it.hasNext() ? it.next() : null));
        }
        return Stream.of(new ListResult(result));
    }

    @Procedure
    @Description(value="apoc.coll.pairs([list]) returns [first,second],[second,third], ...")
    public Stream<ListResult> pairs(@Name(value="list") List<Object> list) {
        return this.zip(list, list.subList(1, list.size()));
    }

    @Procedure
    @Description(value="apoc.coll.sum([0.5,1,2.3])")
    public Stream<DoubleResult> sum(@Name(value="numbers") List<Number> list) {
        double sum = 0.0;
        for (Number number : list) {
            sum += number.doubleValue();
        }
        return Stream.of(new DoubleResult(sum));
    }

    @Procedure
    @Description(value="apoc.coll.min([0.5,1,2.3])")
    public Stream<ObjectResult> min(@Name(value="values") List<Object> list) {
        return Stream.of(new ObjectResult(Collections.min(list)));
    }

    @Procedure
    @Description(value="apoc.coll.max([0.5,1,2.3])")
    public Stream<ObjectResult> max(@Name(value="values") List<Object> list) {
        return Stream.of(new ObjectResult(Collections.max(list)));
    }

    @Procedure
    @Description(value="apoc.coll.partition(list,batchSize)")
    public Stream<ListResult> partition(@Name(value="values") List<Object> list, @Name(value="batchSize") long batchSize) {
        return this.partitionList(list, (int)batchSize).map(ListResult::new);
    }

    private Stream<List<Object>> partitionList(@Name(value="values") List list, @Name(value="batchSize") int batchSize) {
        int total = list.size();
        int pages = total / batchSize + 1;
        return IntStream.range(0, pages).parallel().boxed().map(page -> {
            int from = page * batchSize;
            return list.subList(from, Math.min(from + batchSize, total));
        });
    }

    @Procedure
    @Description(value="apoc.coll.contains(coll, value) optimized contains operation (using a HashSet) (returns single row or not)")
    public Stream<Empty> contains(@Name(value="coll") List<Object> coll, @Name(value="value") Object value) {
        boolean result = new HashSet<Object>(coll).contains(value);
        return Empty.stream(result);
    }

    @Procedure
    @Description(value="apoc.coll.containsAll(coll, values) optimized contains-all operation (using a HashSet) (returns single row or not)")
    public Stream<Empty> containsAll(@Name(value="coll") List<Object> coll, @Name(value="values") List<Object> values) {
        boolean result = new HashSet<Object>(coll).containsAll(values);
        return Empty.stream(result);
    }

    @Procedure
    @Description(value="apoc.coll.containsSorted(coll, value) optimized contains on a sorted list operation (Collections.binarySearch) (returns single row or not)")
    public Stream<Empty> containsSorted(@Name(value="coll") List<Object> coll, @Name(value="value") Object value) {
        int batchSize = 4999;
        ArrayList list = coll instanceof RandomAccess || coll.size() < batchSize ? coll : new ArrayList(coll);
        boolean result = Collections.binarySearch(list, value) >= 0;
        return Empty.stream(result);
    }

    @Procedure
    @Description(value="apoc.coll.containsAllSorted(coll, value) optimized contains-all on a sorted list operation (Collections.binarySearch) (returns single row or not)")
    public Stream<Empty> containsAllSorted(@Name(value="coll") List<Object> coll, @Name(value="values") List<Object> values) {
        int batchSize = 4999;
        ArrayList list = coll instanceof RandomAccess || coll.size() < batchSize ? coll : new ArrayList(coll);
        for (Object value : values) {
            boolean result = Collections.binarySearch(list, value) >= 0;
            if (result) continue;
            return Stream.empty();
        }
        return Empty.stream(true);
    }

    @Procedure
    @Description(value="apoc.coll.toSet([list]) returns a unique list backed by a set")
    public Stream<ListResult> toSet(@Name(value="values") List<Object> list) {
        return Stream.of(new ListResult(new SetBackedList(new LinkedHashSet<Object>(list))));
    }

    @Procedure
    @Description(value="apoc.coll.sumLongs([1,3,3])")
    public Stream<LongResult> sumLongs(@Name(value="numbers") List<Number> list) {
        long sum = 0L;
        for (Number number : list) {
            sum += number.longValue();
        }
        return Stream.of(new LongResult(sum));
    }

    @Procedure
    @Description(value="apoc.coll.sort(coll) sort on Collections")
    public Stream<ListResult> sort(@Name(value="coll") List coll) {
        ArrayList sorted = new ArrayList(coll);
        Collections.sort(sorted);
        return Stream.of(new ListResult(sorted));
    }

    @Procedure
    @Description(value="apoc.coll.sortNodes([nodes], 'name') sort nodes by property")
    public Stream<ListResult> sortNodes(@Name(value="coll") List coll, @Name(value="prop") String prop) {
        ArrayList sorted = new ArrayList(coll);
        Collections.sort(sorted, (x, y) -> Coll.compare(x.getProperty(prop, null), y.getProperty(prop, null)));
        return Stream.of(new ListResult(sorted));
    }

    public static int compare(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            if (o1 instanceof Double || o2 instanceof Double || o1 instanceof Float || o2 instanceof Float) {
                return Double.compare(((Number)o1).doubleValue(), ((Number)o2).doubleValue());
            }
            return Long.compare(((Number)o1).longValue(), ((Number)o2).longValue());
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return (Boolean)o1 != false ? 1 : -1;
        }
        if (o1 instanceof Node && o2 instanceof Node) {
            return Long.compare(((Node)o1).getId(), ((Node)o2).getId());
        }
        if (o1 instanceof Relationship && o2 instanceof Relationship) {
            return Long.compare(((Relationship)o1).getId(), ((Relationship)o2).getId());
        }
        return o1.toString().compareTo(o2.toString());
    }
}

