/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.procedure.validators;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import org.neo4j.tooling.procedure.compilerutils.TypeMirrorUtils;

public class AllowedTypesValidator
implements Predicate<TypeMirror> {
    private final TypeMirrorUtils typeMirrors;
    private final Collection<TypeMirror> whitelistedTypes;
    private final Types typeUtils;

    public AllowedTypesValidator(TypeMirrorUtils typeMirrors, Types typeUtils) {
        this.typeMirrors = typeMirrors;
        this.whitelistedTypes = typeMirrors.procedureAllowedTypes();
        this.typeUtils = typeUtils;
    }

    @Override
    public boolean test(TypeMirror typeMirror) {
        TypeMirror erasedActualType = this.typeUtils.erasure(typeMirror);
        return !(!this.isValidErasedType(erasedActualType) || this.isSameErasedType(List.class, typeMirror) && !this.isValidListType(typeMirror) || this.isSameErasedType(Map.class, typeMirror) && !this.isValidMapType(typeMirror));
    }

    private boolean isValidErasedType(TypeMirror actualType) {
        return this.whitelistedTypes.stream().anyMatch(type -> {
            TypeMirror erasedAllowedType = this.typeUtils.erasure((TypeMirror)type);
            TypeMirror map = this.typeUtils.erasure(this.typeMirrors.typeMirror(Map.class));
            TypeMirror list = this.typeUtils.erasure(this.typeMirrors.typeMirror(List.class));
            if (this.typeUtils.isSameType(erasedAllowedType, map) || this.typeUtils.isSameType(erasedAllowedType, list)) {
                return this.typeUtils.isSubtype(actualType, erasedAllowedType);
            }
            return this.typeUtils.isSameType(actualType, erasedAllowedType);
        });
    }

    private boolean isValidListType(TypeMirror typeMirror) {
        return (Boolean)new SimpleTypeVisitor8<Boolean, Void>(){

            @Override
            public Boolean visitDeclared(DeclaredType list, Void aVoid) {
                List<? extends TypeMirror> typeArguments = list.getTypeArguments();
                return typeArguments.size() == 1 && AllowedTypesValidator.this.test(typeArguments.get(0));
            }
        }.visit(typeMirror);
    }

    private boolean isValidMapType(TypeMirror typeMirror) {
        return (Boolean)new SimpleTypeVisitor8<Boolean, Void>(){

            @Override
            public Boolean visitDeclared(DeclaredType map, Void ignored) {
                List<? extends TypeMirror> typeArguments = map.getTypeArguments();
                if (typeArguments.size() != 2) {
                    return Boolean.FALSE;
                }
                TypeMirror key = typeArguments.get(0);
                return AllowedTypesValidator.this.typeUtils.isSameType(key, AllowedTypesValidator.this.typeMirrors.typeMirror(String.class)) && AllowedTypesValidator.this.test(typeArguments.get(1));
            }
        }.visit(typeMirror);
    }

    private boolean isSameErasedType(Class<?> type, TypeMirror typeMirror) {
        return this.typeUtils.isSameType(this.typeUtils.erasure(this.typeMirrors.typeMirror(type)), this.typeUtils.erasure(typeMirror));
    }
}

