/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.procedure.visitors;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.Types;
import org.neo4j.tooling.procedure.messages.CompilationMessage;
import org.neo4j.tooling.procedure.messages.ProcedureMissingPublicNoArgConstructor;
import org.neo4j.tooling.procedure.visitors.FieldVisitor;

public class StoredProcedureClassVisitor
extends SimpleElementVisitor8<Stream<CompilationMessage>, Void> {
    private final Set<TypeElement> visitedElements = new HashSet<TypeElement>();
    private final FieldVisitor fieldVisitor;

    public StoredProcedureClassVisitor(Types types, Elements elements, boolean skipContextWarnings) {
        this.fieldVisitor = new FieldVisitor(types, elements, skipContextWarnings);
    }

    @Override
    public Stream<CompilationMessage> visitType(TypeElement procedureClass, Void ignored) {
        if (this.isFirstVisit(procedureClass)) {
            return Stream.concat(this.validateFields(procedureClass), this.validateConstructor(procedureClass));
        }
        return Stream.empty();
    }

    private boolean isFirstVisit(TypeElement e) {
        return this.visitedElements.add(e);
    }

    private Stream<CompilationMessage> validateFields(TypeElement e) {
        return e.getEnclosedElements().stream().flatMap(this.fieldVisitor::visit);
    }

    private Stream<CompilationMessage> validateConstructor(Element procedureClass) {
        Optional<ExecutableElement> publicNoArgConstructor = ElementFilter.constructorsIn(procedureClass.getEnclosedElements()).stream().filter(c -> c.getModifiers().contains((Object)Modifier.PUBLIC)).filter(c -> c.getParameters().isEmpty()).findFirst();
        if (!publicNoArgConstructor.isPresent()) {
            return Stream.of(new ProcedureMissingPublicNoArgConstructor(procedureClass, "Procedure class %s should contain a public no-arg constructor, none found.", procedureClass));
        }
        return Stream.empty();
    }
}

