/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v56;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.CheckpointLogEntryWriter;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdSerialization;
import org.neo4j.storageengine.api.TransactionId;

public class DetachedCheckpointLogEntryWriterV5_6
implements CheckpointLogEntryWriter {
    public static final int RECORD_LENGTH_BYTES = 232;
    protected final WritableChecksumChannel channel;

    public DetachedCheckpointLogEntryWriterV5_6(WritableChecksumChannel channel) {
        this.channel = channel;
    }

    @Override
    public void writeCheckPointEntry(TransactionId transactionId, KernelVersion kernelVersion, LogPosition logPosition, Instant checkpointTime, StoreId storeId, String reason) throws IOException {
        this.channel.beginChecksum();
        DetachedCheckpointLogEntryWriterV5_6.writeLogEntryHeader(kernelVersion, (byte)12, (WritableChannel)this.channel);
        byte[] storeIdBuffer = new byte[64];
        StoreIdSerialization.serializeWithFixedSize((StoreId)storeId, (ByteBuffer)ByteBuffer.wrap(storeIdBuffer));
        byte[] reasonBytes = reason.getBytes();
        short length = Numbers.safeCastIntToShort((int)Math.min(reasonBytes.length, 108));
        byte[] descriptionBytes = new byte[108];
        System.arraycopy(reasonBytes, 0, descriptionBytes, 0, length);
        this.channel.putLong(logPosition.getLogVersion()).putLong(logPosition.getByteOffset()).putLong(checkpointTime.toEpochMilli()).put(storeIdBuffer, storeIdBuffer.length).putLong(transactionId.transactionId()).putInt(transactionId.checksum()).putLong(transactionId.commitTimestamp()).putLong(transactionId.consensusIndex()).putShort(length).put(descriptionBytes, descriptionBytes.length);
        this.channel.putChecksum();
    }

    protected static void writeLogEntryHeader(KernelVersion kernelVersion, byte type, WritableChannel channel) throws IOException {
        channel.put(kernelVersion.version()).put(type);
    }
}

