/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v56;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.neo4j.io.fs.ReadableChecksumChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.v56.LogEntryDetachedCheckpointV5_6;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdSerialization;
import org.neo4j.storageengine.api.TransactionId;

public class DetachedCheckpointLogEntryParserV5_6
extends LogEntryParser {
    public static final int MAX_DESCRIPTION_LENGTH = 108;

    public DetachedCheckpointLogEntryParserV5_6() {
        super((byte)12);
    }

    @Override
    public LogEntry parse(KernelVersion version, ReadableChecksumChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
        long logVersion = channel.getLong();
        long byteOffset = channel.getLong();
        long checkpointTimeMillis = channel.getLong();
        byte[] storeIdBuffer = new byte[64];
        channel.get(storeIdBuffer, storeIdBuffer.length);
        StoreId storeId = StoreIdSerialization.deserializeWithFixedSize((ByteBuffer)ByteBuffer.wrap(storeIdBuffer));
        TransactionId transactionId = new TransactionId(channel.getLong(), channel.getInt(), channel.getLong(), channel.getLong());
        short reasonBytesLength = channel.getShort();
        byte[] bytes = new byte[108];
        channel.get(bytes, 108);
        String reason = new String(bytes, 0, (int)reasonBytesLength, StandardCharsets.UTF_8);
        channel.endChecksumAndValidate();
        return new LogEntryDetachedCheckpointV5_6(version, transactionId, new LogPosition(logVersion, byteOffset), checkpointTimeMillis, storeId, reason);
    }
}

