/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.legacy;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChecksumChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.legacy.LegacyInlinedCheckPoint;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class InlineCheckpointLogEntryParser
extends LogEntryParser {
    private final boolean checksum;

    public InlineCheckpointLogEntryParser(boolean checksum) {
        super((byte)7);
        this.checksum = checksum;
    }

    @Override
    public LogEntry parse(KernelVersion version, ReadableChecksumChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
        long logVersion = channel.getLong();
        long byteOffset = channel.getLong();
        if (this.checksum) {
            channel.getInt();
        }
        return new LegacyInlinedCheckPoint(new LogPosition(logVersion, byteOffset));
    }
}

