/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.io.fs.PositionableChannel;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSet;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSets;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.entry.v56.LogEntryRollback;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.util.FeatureToggles;

public class VersionAwareLogEntryReader
implements LogEntryReader {
    private static final boolean VERIFY_CHECKSUM_CHAIN = FeatureToggles.flag(LogEntryReader.class, (String)"verifyChecksumChain", (boolean)false);
    private final CommandReaderFactory commandReaderFactory;
    private final KernelVersion latestRecognizedKernelVersion;
    private final LogPositionMarker positionMarker;
    private final boolean verifyChecksumChain;
    private LogEntryParserSet parserSet;
    private int lastTxChecksum = -559063315;

    public VersionAwareLogEntryReader(CommandReaderFactory commandReaderFactory, KernelVersion latestRecognizedKernelVersion) {
        this(commandReaderFactory, true, latestRecognizedKernelVersion);
    }

    public VersionAwareLogEntryReader(CommandReaderFactory commandReaderFactory, boolean verifyChecksumChain, KernelVersion latestRecognizedKernelVersion) {
        this.commandReaderFactory = commandReaderFactory;
        this.positionMarker = new LogPositionMarker();
        this.verifyChecksumChain = verifyChecksumChain;
        this.latestRecognizedKernelVersion = latestRecognizedKernelVersion;
    }

    @Override
    public LogEntry readLogEntry(ReadableClosablePositionAwareChecksumChannel channel) throws IOException {
        try {
            LogEntry entry;
            byte versionCode = channel.markAndGet(this.positionMarker);
            if (versionCode == 0) {
                if (!(channel instanceof PositionableChannel)) {
                    throw new IllegalStateException("Log reader expects positionable channel to be able to reset offset. Current channel: " + channel);
                }
                this.rewindOneByte(channel);
                return null;
            }
            if (this.parserSet == null || this.parserSet.getIntroductionVersion().version() != versionCode) {
                try {
                    this.parserSet = LogEntryParserSets.parserSet(KernelVersion.getForVersion((byte)versionCode), this.latestRecognizedKernelVersion);
                }
                catch (IllegalArgumentException e) {
                    String msg = this.latestRecognizedKernelVersion.isLessThan(versionCode) ? String.format("Log file contains entries with prefix %d, and the highest supported prefix is %s. This indicates that the log files originates from an newer version of neo4j, which we don't support downgrading from.", versionCode, this.latestRecognizedKernelVersion) : String.format("Log file contains entries with prefix %d, and the lowest supported prefix is %s. This indicates that the log files originates from an older version of neo4j, which we don't support migrations from.", versionCode, KernelVersion.EARLIEST);
                    throw new UnsupportedLogVersionException(msg);
                }
                if (channel instanceof PositionableChannel) {
                    this.rewindOneByte(channel);
                    channel.beginChecksum();
                    channel.get();
                }
            }
            byte typeCode = channel.get();
            try {
                LogEntryParser entryReader = this.parserSet.select(typeCode);
                entry = entryReader.parse(this.parserSet.getIntroductionVersion(), this.parserSet.wrap(channel), this.positionMarker, this.commandReaderFactory);
            }
            catch (ReadPastEndException e) {
                throw e;
            }
            catch (Exception e) {
                LogPosition position = this.positionMarker.newPosition();
                String message = e.getMessage() + ". At position " + position + " and entry version " + versionCode;
                if (e instanceof UnsupportedLogVersionException) {
                    throw new UnsupportedLogVersionException(message, e);
                }
                throw new IOException(message, e);
            }
            this.verifyChecksumChain(entry);
            return entry;
        }
        catch (ReadPastEndException e) {
            return null;
        }
    }

    private void verifyChecksumChain(LogEntry e) {
        if (VERIFY_CHECKSUM_CHAIN && this.verifyChecksumChain) {
            if (e instanceof LogEntryStart) {
                LogEntryStart logEntryStart = (LogEntryStart)e;
                int previousChecksum = logEntryStart.getPreviousChecksum();
                if (this.lastTxChecksum != -559063315 && previousChecksum != this.lastTxChecksum) {
                    throw new IllegalStateException("The checksum chain is broken. " + this.positionMarker);
                }
            } else if (e instanceof LogEntryCommit) {
                LogEntryCommit logEntryCommit = (LogEntryCommit)e;
                this.lastTxChecksum = logEntryCommit.getChecksum();
            } else if (e instanceof LogEntryRollback) {
                LogEntryRollback rollback = (LogEntryRollback)e;
                this.lastTxChecksum = rollback.getChecksum();
            }
        }
    }

    private void rewindOneByte(ReadableClosablePositionAwareChecksumChannel channel) throws IOException {
        channel.getCurrentPosition(this.positionMarker);
        ((PositionableChannel)channel).setCurrentPosition(this.positionMarker.getByteOffset() - 1L);
        channel.getCurrentPosition(this.positionMarker);
    }

    @Override
    public LogPosition lastPosition() {
        return this.positionMarker.newPosition();
    }
}

