/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.util.EnumMap;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LegacyLogEntryParserSetV2_3;
import org.neo4j.kernel.impl.transaction.log.entry.LegacyLogEntryParserSetV4_0;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSet;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetV4_2;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetV4_3;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetV4_4;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetV5_0;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetV5_6;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSetVGloriousFuture;

public class LogEntryParserSets {
    private static final EnumMap<KernelVersion, LogEntryParserSet> PARSER_SETS = new EnumMap(KernelVersion.class);

    public static LogEntryParserSet parserSet(KernelVersion version, KernelVersion latestRecognizedKernelVersion) {
        LogEntryParserSet parserSet = PARSER_SETS.get(version);
        if (parserSet == null) {
            if (version == KernelVersion.GLORIOUS_FUTURE && latestRecognizedKernelVersion.isAtLeast(version)) {
                return new LogEntryParserSetVGloriousFuture();
            }
            throw new IllegalStateException(String.format("No log entries version matching %s", version));
        }
        return parserSet;
    }

    static {
        PARSER_SETS.put(KernelVersion.V2_3, new LegacyLogEntryParserSetV2_3());
        PARSER_SETS.put(KernelVersion.V4_0, new LegacyLogEntryParserSetV4_0());
        PARSER_SETS.put(KernelVersion.V4_2, new LogEntryParserSetV4_2());
        PARSER_SETS.put(KernelVersion.V4_3_D4, new LogEntryParserSetV4_3());
        PARSER_SETS.put(KernelVersion.V4_4, new LogEntryParserSetV4_4());
        PARSER_SETS.put(KernelVersion.V5_0, new LogEntryParserSetV5_0());
        PARSER_SETS.put(KernelVersion.V5_6, new LogEntryParserSetV5_6());
    }
}

