/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v42;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.v42.LogEntryDetachedCheckpointV4_2;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StoreId;

public class DetachedCheckpointLogEntrySerializerV4_2
extends LogEntrySerializer<LogEntryDetachedCheckpointV4_2> {
    public static final int MAX_DESCRIPTION_LENGTH = 120;

    public DetachedCheckpointLogEntrySerializerV4_2() {
        super((byte)8);
    }

    @Override
    public LogEntryDetachedCheckpointV4_2 parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
        long logVersion = channel.getLong();
        long byteOffset = channel.getLong();
        long checkpointTimeMillis = channel.getLong();
        StoreId storeId = this.constructStoreIdFromLegacyInfo(channel.getLong(), channel.getLong());
        channel.getLong();
        channel.getLong();
        channel.getLong();
        short reasonBytesLength = channel.getShort();
        byte[] bytes = new byte[120];
        channel.get(bytes, 120);
        String reason = new String(bytes, 0, (int)reasonBytesLength, StandardCharsets.UTF_8);
        channel.endChecksumAndValidate();
        return new LogEntryDetachedCheckpointV4_2(version, new LogPosition(logVersion, byteOffset), checkpointTimeMillis, storeId, reason);
    }

    @Override
    public int write(WritableChannel channel, LogEntryDetachedCheckpointV4_2 logEntry) throws IOException {
        throw new UnsupportedOperationException("Unable to write old detached checkpoint log entry.");
    }

    private StoreId constructStoreIdFromLegacyInfo(long creationTime, long randomId) {
        return new StoreId(creationTime, randomId, "legacy", "legacy", 1, 1);
    }
}

