/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSet;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSets;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryRollback;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.util.FeatureToggles;

public class VersionAwareLogEntryReader
implements LogEntryReader {
    private static final boolean VERIFY_CHECKSUM_CHAIN = FeatureToggles.flag(LogEntryReader.class, (String)"verifyChecksumChain", (boolean)false);
    private final CommandReaderFactory commandReaderFactory;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private final LogPositionMarker positionMarker;
    private final boolean verifyChecksumChain;
    private boolean brokenLastEntry;
    private LogEntrySerializationSet parserSet;
    private int lastTxChecksum = -559063315;

    public VersionAwareLogEntryReader(CommandReaderFactory commandReaderFactory, BinarySupportedKernelVersions binarySupportedKernelVersions) {
        this(commandReaderFactory, true, binarySupportedKernelVersions);
    }

    public VersionAwareLogEntryReader(CommandReaderFactory commandReaderFactory, boolean verifyChecksumChain, BinarySupportedKernelVersions binarySupportedKernelVersions) {
        this.commandReaderFactory = commandReaderFactory;
        this.positionMarker = new LogPositionMarker();
        this.verifyChecksumChain = verifyChecksumChain;
        this.binarySupportedKernelVersions = binarySupportedKernelVersions;
    }

    @Override
    public LogEntry readLogEntry(ReadableLogPositionAwareChannel channel) throws IOException {
        long entryStartPosition = channel.position();
        try {
            byte versionCode = channel.markAndGetVersion(this.positionMarker);
            if (versionCode == 0) {
                VersionAwareLogEntryReader.checkSmallChunkOfTail(channel, channel.getCurrentLogPosition(), null);
                this.rewindToEntryStartPosition(channel, this.positionMarker, entryStartPosition);
                return null;
            }
            this.updateParserSet(channel, versionCode, entryStartPosition);
            byte typeCode = channel.get();
            LogEntry entry = this.readEntry(channel, versionCode, typeCode);
            this.verifyChecksumChain(entry);
            return entry;
        }
        catch (ReadPastEndException e) {
            return null;
        }
        catch (IllegalStateException | UnsupportedLogVersionException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            LogPosition currentLogPosition = channel.getCurrentLogPosition();
            VersionAwareLogEntryReader.checkTail(channel, currentLogPosition, e);
            this.brokenLastEntry = true;
            this.rewindToEntryStartPosition(channel, this.positionMarker, entryStartPosition);
            return null;
        }
    }

    public boolean hasBrokenLastEntry() {
        return this.brokenLastEntry;
    }

    private static void checkTail(ReadableLogPositionAwareChannel channel, LogPosition currentLogPosition, Exception e) throws IOException {
        VersionAwareLogEntryReader.checkTail(channel, currentLogPosition, (int)ByteUnit.kibiBytes((long)16L), true, e);
    }

    private static void checkSmallChunkOfTail(ReadableLogPositionAwareChannel channel, LogPosition currentLogPosition, Exception e) throws IOException {
        VersionAwareLogEntryReader.checkTail(channel, currentLogPosition, (int)ByteUnit.kibiBytes((long)1L), false, e);
    }

    private static void checkTail(ReadableLogPositionAwareChannel channel, LogPosition currentLogPosition, int bufferSize, boolean checkToEnd, Exception e) throws IOException {
        byte[] zeroArray = new byte[bufferSize];
        try (HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(bufferSize, ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            ByteBuffer buffer = scopedBuffer.getBuffer();
            boolean endReached = false;
            do {
                try {
                    channel.read(buffer);
                }
                catch (ReadPastEndException ee) {
                    endReached = true;
                }
                buffer.flip();
                if (Arrays.mismatch(buffer.array(), 0, buffer.limit(), zeroArray, 0, buffer.limit()) == -1) continue;
                throw new IllegalStateException("Failure to read transaction log file number " + currentLogPosition.getLogVersion() + ". Unreadable bytes are encountered after last readable position.", e);
            } while (!endReached && checkToEnd);
        }
    }

    private void updateParserSet(ReadableLogPositionAwareChannel channel, byte versionCode, long entryStartPosition) throws IOException {
        if (this.parserSet != null && this.parserSet.getIntroductionVersion().version() == versionCode) {
            return;
        }
        try {
            KernelVersion kernelVersion = KernelVersion.getForVersion((byte)versionCode);
            this.parserSet = LogEntrySerializationSets.serializationSet(kernelVersion, this.binarySupportedKernelVersions);
            if (kernelVersion.isLessThan(KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED)) {
                this.rewindOneByte(channel);
                channel.beginChecksum();
                channel.get();
            }
        }
        catch (IllegalArgumentException e) {
            throw UnsupportedLogVersionException.unsupported(this.binarySupportedKernelVersions, versionCode);
        }
    }

    private void rewindOneByte(ReadableLogPositionAwareChannel channel) throws IOException {
        channel.position(channel.position() - 1L);
        channel.getCurrentLogPosition(this.positionMarker);
    }

    private LogEntry readEntry(ReadableLogPositionAwareChannel channel, byte versionCode, byte typeCode) throws IOException {
        try {
            return this.parserSet.select(typeCode).parse(this.parserSet.getIntroductionVersion(), this.parserSet.wrap(channel), this.positionMarker, this.commandReaderFactory);
        }
        catch (ReadPastEndException e) {
            throw e;
        }
        catch (Exception e) {
            LogPosition position = this.positionMarker.newPosition();
            String message = e.getMessage() + ". At position " + String.valueOf(position) + " and entry version " + versionCode;
            if (e instanceof UnsupportedLogVersionException) {
                throw new UnsupportedLogVersionException(versionCode, message, e);
            }
            throw new IOException(message, e);
        }
    }

    private void verifyChecksumChain(LogEntry e) {
        if (VERIFY_CHECKSUM_CHAIN && this.verifyChecksumChain) {
            if (e instanceof LogEntryStart) {
                LogEntryStart logEntryStart = (LogEntryStart)e;
                int previousChecksum = logEntryStart.getPreviousChecksum();
                if (this.lastTxChecksum != -559063315 && previousChecksum != this.lastTxChecksum) {
                    throw new IllegalStateException("The checksum chain is broken. " + String.valueOf(this.positionMarker));
                }
            } else if (e instanceof LogEntryCommit) {
                LogEntryCommit logEntryCommit = (LogEntryCommit)e;
                this.lastTxChecksum = logEntryCommit.getChecksum();
            } else if (e instanceof LogEntryRollback) {
                LogEntryRollback rollback = (LogEntryRollback)e;
                this.lastTxChecksum = rollback.getChecksum();
            }
        }
    }

    private void rewindToEntryStartPosition(ReadableLogPositionAwareChannel channel, LogPositionMarker positionMarker, long position) throws IOException {
        channel.position(position);
        channel.getCurrentLogPosition(positionMarker);
    }

    @Override
    public LogPosition lastPosition() {
        return this.positionMarker.newPosition();
    }
}

