/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.cursor.RawCursor;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeReadChannel;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopedLogFiles;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogChannelContext;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogsRepository;

public class MetadataCursor
implements RawCursor<LogHeader, IOException> {
    private final LogsRepository logsRepository;
    private final long[] versions;
    private final EnvelopedLogFiles logFiles;
    private int currentVersionIndex = -1;
    private EnvelopeReadChannel channel;
    private boolean closed;
    private Path currentPath;

    MetadataCursor(LogsRepository logsRepository, EnvelopedLogFiles logFiles, boolean reversed) throws IOException {
        this.logsRepository = logsRepository;
        this.versions = logsRepository.logVersions(reversed);
        this.logFiles = logFiles;
    }

    public boolean next() throws IOException {
        if (this.closed) {
            return false;
        }
        if (++this.currentVersionIndex >= this.versions.length) {
            return false;
        }
        long version = this.currentVersion();
        LogChannelContext<StoreChannel> logChannel = this.logsRepository.openReadChannel(version);
        this.currentPath = logChannel.path();
        if (this.channel != null) {
            this.channel.close();
        }
        this.channel = this.logFiles.envelopedReadChannel(logChannel, version);
        return true;
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.closed = true;
        }
    }

    public Path currentPath() {
        return this.currentPath;
    }

    long currentVersion() {
        return this.versions[this.currentVersionIndex];
    }

    public LogHeader get() {
        return this.channel != null ? this.channel.logHeader() : null;
    }
}

