/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.log.LogTracers;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeReadChannel;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeReadChannelProvider;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeWriteChannel;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogChannelContext;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogHeaderFactory;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogsRepository;
import org.neo4j.kernel.impl.transaction.log.enveloped.MetadataCursor;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotateEvent;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotateEvents;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.memory.MemoryTracker;

public class EnvelopedLogFiles
implements EnvelopeReadChannelProvider,
AutoCloseable {
    public static final int INITIAL_CHECKSUM = 0;
    public static final long BASE_INDEX = 0L;
    private final int segmentBlockSize;
    private final int writerBufferedBlocks;
    private final MemoryTracker memoryTracker;
    private final LogRotation logRotation;
    private final LogTracers logTracers = LogTracers.NULL;
    private final LogsRepository logsRepository;
    private final long maxFileSize;
    private final LogHeaderFactory logHeaderFactory;
    private LogChannelContext<StoreChannel> currentWriteChannel;
    private EnvelopeWriteChannel appendingChannel;

    public EnvelopedLogFiles(FileSystemAbstraction fs, Path fileName, LogHeaderFactory logHeaderFactory, int segmentBlockSize, int writerBufferedBlocks, int totalSegments, MemoryTracker memoryTracker) {
        if (totalSegments < 2) {
            throw new IllegalArgumentException("Must have at least 2 segments. Got " + totalSegments);
        }
        this.logHeaderFactory = logHeaderFactory;
        this.logsRepository = new LogsRepository(fs, fileName.getParent(), fileName.getFileName().toString());
        this.segmentBlockSize = segmentBlockSize;
        this.writerBufferedBlocks = writerBufferedBlocks;
        this.memoryTracker = memoryTracker;
        this.maxFileSize = (long)totalSegments * (long)segmentBlockSize;
        this.logRotation = new EnvelopedLogRotation(this, this.maxFileSize);
    }

    public EnvelopeWriteChannel currentWriteChannel() {
        if (this.appendingChannel == null) {
            throw new IllegalStateException("Writer channel has not been initialised");
        }
        return this.appendingChannel;
    }

    @Override
    public EnvelopeReadChannel openReadChannel() throws IOException {
        if (this.logsRepository.isEmpty()) {
            throw new IllegalStateException("No log files found " + String.valueOf(this.logsRepository));
        }
        long version = this.logsRepository.logVersions(false)[0];
        return this.envelopedReadChannel(this.logsRepository.openReadChannel(version), version);
    }

    @Override
    public EnvelopeReadChannel openReadChannel(long fileWithIndex) throws IOException {
        long desiredVersion = -1L;
        try (MetadataCursor metadataCursor = new MetadataCursor(this.logsRepository, this, true);){
            while (metadataCursor.next()) {
                LogHeader logHeader = metadataCursor.get();
                if (logHeader.getLastAppendIndex() >= fileWithIndex) continue;
                desiredVersion = metadataCursor.currentVersion();
                break;
            }
        }
        if (desiredVersion == -1L) {
            return null;
        }
        return this.envelopedReadChannel(this.logsRepository.openReadChannel(desiredVersion), desiredVersion);
    }

    public long initialise() throws IOException {
        this.logsRepository.initialise();
        if (this.logsRepository.isEmpty()) {
            LogChannelContext<StoreChannel> logChannelCtx = this.createNewStoreChannel(0L, this.logHeaderFactory.createLogHeader(0L, -1L, 0, this.segmentBlockSize));
            this.updateState(logChannelCtx, 0, -1L);
            return -1L;
        }
        try (EnvelopeReadChannel envelopeReadChannel = this.openReadChannel();){
            try {
                while (true) {
                    envelopeReadChannel.goToNextEntry();
                }
            }
            catch (ReadPastEndException readPastEndException) {
                int prevChecksum = envelopeReadChannel.getChecksum();
                long prevIndex = envelopeReadChannel.entryIndex();
                LogChannelContext<StoreChannel> logChannelCtx = this.openWriteChannel(envelopeReadChannel.getLogVersion(), envelopeReadChannel.position());
                this.updateState(logChannelCtx, prevChecksum, prevIndex);
                long l = prevIndex;
                return l;
            }
        }
    }

    public EnvelopeWriteChannel truncate(long fromIndex) throws IOException {
        long version;
        int prevChecksum;
        long position;
        long lastAppendedIndex;
        if (fromIndex < 0L) {
            throw new IllegalArgumentException("Negative values is not allowed " + fromIndex);
        }
        long l = lastAppendedIndex = this.appendingChannel == null ? -1L : this.appendingChannel.currentIndex();
        if (this.appendingChannel != null && fromIndex > lastAppendedIndex) {
            throw new IllegalArgumentException("Cannot truncate at index " + fromIndex + " when last appended index is " + lastAppendedIndex);
        }
        try (EnvelopeReadChannel readChannel = this.openReadChannel(fromIndex);){
            if (readChannel == null) {
                throw new IllegalArgumentException(fromIndex + " has been pruned");
            }
            position = readChannel.position();
            prevChecksum = readChannel.logHeader().getPreviousLogFileChecksum();
            while (readChannel.entryIndex() < fromIndex) {
                prevChecksum = readChannel.getChecksum();
                position = readChannel.goToNextEnvelope();
            }
            version = readChannel.getLogVersion();
        }
        if (this.currentWriteChannel.version() != version) {
            this.appendingChannel = null;
            this.currentWriteChannel.channel().close();
            this.currentWriteChannel = null;
            this.logsRepository.deleteLogFilesFrom(version + 1L);
            this.currentWriteChannel = this.openWriteChannel(version, position);
            this.appendingChannel = this.envelopedWriteChannel(this.currentWriteChannel, -1, Integer.MAX_VALUE);
        }
        this.appendingChannel.truncateToPosition(position, prevChecksum, fromIndex - 1L);
        return this.appendingChannel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long prune(long index) throws IOException {
        if (index > this.appendingChannel.currentIndex()) {
            long nextVersion = this.logsRepository.logVersionsRange().to() + 1L;
            this.logsRepository.deleteLogFilesFrom(0L);
            LogChannelContext<StoreChannel> newStoreChannel = this.createNewStoreChannel(nextVersion, this.logHeaderFactory.createLogHeader(nextVersion, index, 0, this.segmentBlockSize));
            this.updateState(newStoreChannel, 0, index);
            return index;
        }
        try (EnvelopeReadChannel reader = this.openReadChannel(index);){
            if (reader == null) {
                long l = -1L;
                return l;
            }
            reader.alignWithStartEntry();
            long logVersion = reader.getLogVersion();
            long pruneToVersion = logVersion - 1L;
            if (!this.logsRepository.logVersionsRange().isWithinRange(pruneToVersion)) {
                long l = -1L;
                return l;
            }
            this.logsRepository.deleteLogFilesTo(pruneToVersion);
            long l = reader.entryIndex() - 1L;
            return l;
        }
        catch (ReadPastEndException e) {
            throw new IllegalStateException("Prune index " + index + " was lower than current write index " + this.appendingChannel.currentIndex() + " but did not exist in the log");
        }
    }

    private void rotateCurrentFile() throws IOException {
        if (this.appendingChannel == null) {
            throw new IllegalStateException("Cannot rotate if not initialised");
        }
        long nextVersion = this.currentWriteChannel.version() + 1L;
        LogChannelContext<StoreChannel> newStoreChannel = this.createNewStoreChannel(nextVersion, this.logHeaderFactory.createLogHeader(nextVersion, this.appendingChannel.currentIndex(), this.appendingChannel.currentChecksum(), this.segmentBlockSize));
        this.appendingChannel.prepareForFlush().flush();
        this.currentWriteChannel.channel().truncate(this.currentWriteChannel.channel().position());
        this.updateState(newStoreChannel, this.appendingChannel.currentChecksum(), this.appendingChannel.currentIndex());
    }

    @Override
    public void close() throws Exception {
        if (this.appendingChannel != null) {
            this.appendingChannel.close();
            this.currentWriteChannel = null;
        }
    }

    private void updateState(LogChannelContext<StoreChannel> logChannelCtx, int checksumAtPosition, long prevIndex) throws IOException {
        if (this.appendingChannel == null) {
            this.appendingChannel = this.envelopedWriteChannel(logChannelCtx, checksumAtPosition, prevIndex);
        } else {
            this.appendingChannel.prepareForFlush().flush();
            this.currentWriteChannel.channel().flush();
            if (prevIndex != this.appendingChannel.currentIndex()) {
                this.appendingChannel = this.envelopedWriteChannel(logChannelCtx, checksumAtPosition, prevIndex);
            } else {
                this.appendingChannel.setChannel(logChannelCtx.channel());
            }
            this.currentWriteChannel.channel().close();
        }
        this.currentWriteChannel = logChannelCtx;
    }

    private LogChannelContext<StoreChannel> createNewStoreChannel(long version, LogHeader logHeader) throws IOException {
        LogChannelContext<StoreChannel> logChannelCtx = this.logsRepository.createWriteChannel(version);
        this.preallocate(logChannelCtx);
        logChannelCtx.channel().position(0L);
        LogFormat.writeLogHeader(logChannelCtx.channel(), logHeader, this.memoryTracker);
        logChannelCtx.channel().flush();
        logChannelCtx.channel().position((long)this.segmentBlockSize);
        return logChannelCtx;
    }

    private void preallocate(LogChannelContext<StoreChannel> logChannelCtx) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.segmentBlockSize]);
        for (long preallocated = 0L; preallocated != this.maxFileSize; preallocated += (long)this.segmentBlockSize) {
            buffer.position(0);
            logChannelCtx.channel().write(buffer);
        }
    }

    private LogChannelContext<StoreChannel> openWriteChannel(long version, long position) throws IOException {
        LogChannelContext<StoreChannel> logChannelCtx = this.logsRepository.openWriteChannel(version);
        position = position == 0L ? (long)this.segmentBlockSize : position;
        logChannelCtx.channel().position(position);
        return logChannelCtx;
    }

    private EnvelopeWriteChannel envelopedWriteChannel(LogChannelContext<StoreChannel> logChannelCtx, int checksumAtPosition, long prevIndex) throws IOException {
        return new EnvelopeWriteChannel(logChannelCtx.channel(), (ScopedBuffer)this.scoopedBuffer(), this.segmentBlockSize, checksumAtPosition, prevIndex, this.logTracers, this.logRotation);
    }

    private HeapScopedBuffer scoopedBuffer() {
        return new HeapScopedBuffer(this.writerBufferedBlocks * this.segmentBlockSize, ByteOrder.LITTLE_ENDIAN, this.memoryTracker);
    }

    EnvelopeReadChannel envelopedReadChannel(LogChannelContext<StoreChannel> logChannelCtx, long version) throws IOException {
        PhysicalLogVersionedStoreChannel logVersionedChannel = this.logVersionedChannel(logChannelCtx, version);
        return new EnvelopeReadChannel((LogVersionedStoreChannel)logVersionedChannel, this.segmentBlockSize, (LogVersionBridge)new EnvelopedLogVersionBridge(this), this.memoryTracker, false);
    }

    private PhysicalLogVersionedStoreChannel logVersionedChannel(LogChannelContext<StoreChannel> logChannelCtx, long version) throws IOException {
        return new PhysicalLogVersionedStoreChannel(logChannelCtx.channel(), version, LogFormat.V9, logChannelCtx.path(), ChannelNativeAccessor.EMPTY_ACCESSOR, this.logTracers);
    }

    private LogVersionedStoreChannel safeOpenChannel(long version) throws IOException {
        LongRange longRange = this.logsRepository.logVersionsRange();
        if (longRange.isWithinRange(version)) {
            return this.logVersionedChannel(this.logsRepository.openReadChannel(version), version);
        }
        return null;
    }

    public MetadataCursor metadataCursor() throws IOException {
        return new MetadataCursor(this.logsRepository, this, false);
    }

    private static class EnvelopedLogRotation
    implements LogRotation {
        private final EnvelopedLogFiles envelopedLogFiles;
        private final long maxFileSize;

        EnvelopedLogRotation(EnvelopedLogFiles envelopedLogFiles, long maxFileSize) {
            this.envelopedLogFiles = envelopedLogFiles;
            this.maxFileSize = maxFileSize;
        }

        @Override
        public boolean rotateLogIfNeeded(LogRotateEvents logRotateEvents) {
            throw new UnsupportedOperationException("envelope channel rotation checks are done internally");
        }

        @Override
        public boolean locklessBatchedRotateLogIfNeeded(LogRotateEvents logRotateEvents, long lastAppendIndex, KernelVersion kernelVersion, int checksum) throws IOException {
            throw new UnsupportedOperationException("envelope channel rotation checks are done internally");
        }

        @Override
        public boolean locklessRotateLogIfNeeded(LogRotateEvents logRotateEvents) {
            return this.rotateLogIfNeeded(logRotateEvents);
        }

        @Override
        public boolean locklessRotateLogIfNeeded(LogRotateEvents logRotateEvents, KernelVersion kernelVersion, boolean force) {
            throw new UnsupportedOperationException("envelope channel rotation checks are done internally");
        }

        @Override
        public void rotateLogFile(LogRotateEvents logRotateEvents) throws IOException {
            try (LogRotateEvent event = logRotateEvents.beginLogRotate();){
                this.envelopedLogFiles.rotateCurrentFile();
                event.rotationCompleted(0L);
            }
        }

        @Override
        public void locklessRotateLogFile(LogRotateEvents logRotateEvents, KernelVersion kernelVersion, long lastAppendIndex, int previousChecksum) throws IOException {
            throw new UnsupportedOperationException("envelope channel rotation checks are done internally");
        }

        @Override
        public long rotationSize() {
            return this.maxFileSize;
        }
    }

    private static class EnvelopedLogVersionBridge
    implements LogVersionBridge {
        private final EnvelopedLogFiles envelopedLogFiles;

        public EnvelopedLogVersionBridge(EnvelopedLogFiles envelopedLogFiles) {
            this.envelopedLogFiles = envelopedLogFiles;
        }

        @Override
        public LogVersionedStoreChannel next(LogVersionedStoreChannel channel, boolean raw) throws IOException {
            LogVersionedStoreChannel nextChannel = this.envelopedLogFiles.safeOpenChannel(channel.getLogVersion() + 1L);
            if (nextChannel != null) {
                channel.close();
                return nextChannel;
            }
            return channel;
        }
    }
}

