/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.neo4j.kernel.KernelVersion;

public record LogEnvelopeHeader(EnvelopeType type, long index, int payLoadLength, KernelVersion version, int previousChecksum, int payloadChecksum) {
    public static final int HEADER_SIZE = 22;
    public static final int MAX_ZERO_PADDING_SIZE = 30;
    public static final byte IGNORE_KERNEL_VERSION = -1;

    public static enum EnvelopeType {
        ZERO(0),
        FULL(1),
        BEGIN(2),
        MIDDLE(3),
        END(4),
        START_OFFSET(5);

        private static final EnvelopeType[] VALUES;
        public final byte typeValue;

        private EnvelopeType(byte typeValue) {
            this.typeValue = typeValue;
        }

        public boolean isStarting() {
            return this == FULL || this == BEGIN;
        }

        public boolean isTerminating() {
            return this == FULL || this == END;
        }

        public static EnvelopeType of(byte type) {
            return VALUES[type];
        }

        static {
            VALUES = EnvelopeType.values();
        }
    }
}

