/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v520;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.v520.LogEntryChunkStartV5_20;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class ChunkStartLogEntrySerializerV5_20
extends LogEntrySerializer<LogEntryChunkStartV5_20> {
    public ChunkStartLogEntrySerializerV5_20() {
        super((byte)10);
    }

    @Override
    public LogEntryChunkStartV5_20 parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
        long timeWritten = channel.getLong();
        long chunkId = channel.getLong();
        long logVersion = channel.getLong();
        long offset = channel.getLong();
        long appendIndex = channel.getLong();
        return new LogEntryChunkStartV5_20(version, timeWritten, chunkId, appendIndex, new LogPosition(logVersion, offset));
    }

    @Override
    public int write(WritableChannel channel, LogEntryChunkStartV5_20 logEntry) throws IOException {
        channel.beginChecksumForWriting();
        ChunkStartLogEntrySerializerV5_20.writeLogEntryHeader(logEntry.kernelVersion(), (byte)10, channel);
        LogPosition previousChunkStart = logEntry.getPreviousBatchLogPosition();
        channel.putLong(logEntry.getTimeWritten()).putLong(logEntry.getChunkId()).putLong(previousChunkStart.getLogVersion()).putLong(previousChunkStart.getByteOffset()).putLong(logEntry.getAppendIndex());
        return 0;
    }
}

