/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v520;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.v520.LogEntryStartV5_20;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class StartLogEntrySerializerV5_20
extends LogEntrySerializer<LogEntryStartV5_20> {
    public StartLogEntrySerializerV5_20() {
        super((byte)1);
    }

    @Override
    public LogEntryStartV5_20 parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
        LogPosition position = marker.newPosition();
        long timeWritten = channel.getLong();
        long latestCommittedTxWhenStarted = channel.getLong();
        int previousChecksum = channel.getInt();
        long appendIndex = channel.getLong();
        int additionalHeaderLength = channel.getInt();
        byte[] additionalHeader = new byte[additionalHeaderLength];
        channel.get(additionalHeader, additionalHeaderLength);
        return new LogEntryStartV5_20(version, timeWritten, latestCommittedTxWhenStarted, appendIndex, previousChecksum, additionalHeader, position);
    }

    @Override
    public int write(WritableChannel channel, LogEntryStartV5_20 logEntry) throws IOException {
        channel.beginChecksumForWriting();
        StartLogEntrySerializerV5_20.writeLogEntryHeader(logEntry.kernelVersion(), (byte)1, channel);
        byte[] additionalHeaderData = logEntry.getAdditionalHeader();
        channel.putLong(logEntry.getTimeWritten()).putLong(logEntry.getLastCommittedTxWhenTransactionStarted()).putInt(logEntry.getPreviousChecksum()).putLong(logEntry.getAppendIndex()).putInt(additionalHeaderData.length).put(additionalHeaderData, additionalHeaderData.length);
        return 0;
    }
}

