/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSet;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSets;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryRollback;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.util.FeatureToggles;

public class VersionAwareLogEntryReader
implements LogEntryReader {
    private static final boolean VERIFY_CHECKSUM_CHAIN = FeatureToggles.flag(LogEntryReader.class, (String)"verifyChecksumChain", (boolean)false);
    private final CommandReaderFactory commandReaderFactory;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private final LogPositionMarker positionMarker;
    private final boolean verifyChecksumChain;
    private LogEntrySerializationSet parserSet;
    private int lastTxChecksum = -559063315;

    public VersionAwareLogEntryReader(CommandReaderFactory commandReaderFactory, BinarySupportedKernelVersions binarySupportedKernelVersions) {
        this(commandReaderFactory, true, binarySupportedKernelVersions);
    }

    public VersionAwareLogEntryReader(CommandReaderFactory commandReaderFactory, boolean verifyChecksumChain, BinarySupportedKernelVersions binarySupportedKernelVersions) {
        this.commandReaderFactory = commandReaderFactory;
        this.positionMarker = new LogPositionMarker();
        this.verifyChecksumChain = verifyChecksumChain;
        this.binarySupportedKernelVersions = binarySupportedKernelVersions;
    }

    @Override
    public LogEntry readLogEntry(ReadableLogPositionAwareChannel channel) throws IOException {
        try {
            byte versionCode = channel.markAndGetVersion(this.positionMarker);
            if (versionCode == 0) {
                this.rewindOneByte(channel);
                return null;
            }
            this.updateParserSet(channel, versionCode);
            byte typeCode = channel.get();
            LogEntry entry = this.readEntry(channel, versionCode, typeCode);
            this.verifyChecksumChain(entry);
            return entry;
        }
        catch (ReadPastEndException e) {
            return null;
        }
    }

    private void updateParserSet(ReadableLogPositionAwareChannel channel, byte versionCode) throws IOException {
        if (this.parserSet != null && this.parserSet.getIntroductionVersion().version() == versionCode) {
            return;
        }
        try {
            this.parserSet = LogEntrySerializationSets.serializationSet(KernelVersion.getForVersion((byte)versionCode), this.binarySupportedKernelVersions);
        }
        catch (IllegalArgumentException e) {
            throw UnsupportedLogVersionException.unsupported(this.binarySupportedKernelVersions, versionCode);
        }
        this.rewindOneByte(channel);
        channel.beginChecksum();
        channel.get();
    }

    private LogEntry readEntry(ReadableLogPositionAwareChannel channel, byte versionCode, byte typeCode) throws IOException {
        try {
            return this.parserSet.select(typeCode).parse(this.parserSet.getIntroductionVersion(), this.parserSet.wrap(channel), this.positionMarker, this.commandReaderFactory);
        }
        catch (ReadPastEndException e) {
            throw e;
        }
        catch (Exception e) {
            LogPosition position = this.positionMarker.newPosition();
            String message = e.getMessage() + ". At position " + position + " and entry version " + versionCode;
            if (e instanceof UnsupportedLogVersionException) {
                throw new UnsupportedLogVersionException(versionCode, message, e);
            }
            throw new IOException(message, e);
        }
    }

    private void verifyChecksumChain(LogEntry e) {
        if (VERIFY_CHECKSUM_CHAIN && this.verifyChecksumChain) {
            if (e instanceof LogEntryStart) {
                LogEntryStart logEntryStart = (LogEntryStart)e;
                int previousChecksum = logEntryStart.getPreviousChecksum();
                if (this.lastTxChecksum != -559063315 && previousChecksum != this.lastTxChecksum) {
                    throw new IllegalStateException("The checksum chain is broken. " + this.positionMarker);
                }
            } else if (e instanceof LogEntryCommit) {
                LogEntryCommit logEntryCommit = (LogEntryCommit)e;
                this.lastTxChecksum = logEntryCommit.getChecksum();
            } else if (e instanceof LogEntryRollback) {
                LogEntryRollback rollback = (LogEntryRollback)e;
                this.lastTxChecksum = rollback.getChecksum();
            }
        }
    }

    private void rewindOneByte(ReadableLogPositionAwareChannel channel) throws IOException {
        channel.position(channel.position() - 1L);
        channel.getCurrentLogPosition(this.positionMarker);
    }

    @Override
    public LogPosition lastPosition() {
        return this.positionMarker.newPosition();
    }
}

