/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdSerialization;

public enum LogFormat {
    V6(6, 16, KernelVersion.V2_3, KernelVersion.V2_3, (logVersion, buffer) -> {
        long previousCommittedTx = buffer.getLong();
        return new LogHeader(6, new LogPosition(logVersion, 16L), previousCommittedTx, null, -1, -559063315);
    }),
    V7(7, 64, KernelVersion.V4_2, KernelVersion.V4_4, (logVersion, buffer) -> {
        long previousCommittedTx = buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        return new LogHeader(7, new LogPosition(logVersion, 64L), previousCommittedTx, null, -1, -559063315);
    }),
    V8(8, 128, KernelVersion.V5_0, KernelVersion.getLatestVersion((Config)Config.defaults()), (logVersion, buffer) -> {
        long previousCommittedTx = buffer.getLong();
        StoreId storeId = StoreIdSerialization.deserializeWithFixedSize((ByteBuffer)buffer);
        buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        return new LogHeader(8, new LogPosition(logVersion, 128L), previousCommittedTx, storeId, -1, -559063315);
    }),
    V9(9, 128, KernelVersion.GLORIOUS_FUTURE, KernelVersion.GLORIOUS_FUTURE, (logVersion, buffer) -> {
        long previousCommittedTx = buffer.getLong();
        StoreId storeId = StoreIdSerialization.deserializeWithFixedSize((ByteBuffer)buffer);
        int segmentBlockSize = buffer.getInt();
        int previousChecksum = buffer.getInt();
        buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        buffer.getLong();
        return new LogHeader(9, new LogPosition(logVersion, (long)segmentBlockSize), previousCommittedTx, storeId, segmentBlockSize, previousChecksum);
    });

    private static final long LOG_VERSION_BITS = 56L;
    private static final long LOG_VERSION_MASK = 0xFFFFFFFFFFFFFFL;
    private final byte versionByte;
    private final int headerSize;
    private final KernelVersion fromKernelVersion;
    private final KernelVersion toKernelVersion;
    private final LogFormatHeaderParser headerParser;
    public static final byte CURRENT_LOG_FORMAT_VERSION;
    public static final int CURRENT_FORMAT_LOG_HEADER_SIZE;
    public static final int BIGGEST_HEADER;
    private static final LogFormat[] BY_VERSION_BYTE;
    private static final EnumMap<KernelVersion, LogFormat> KERNEL_VERSION_TO_LOG_FORMAT;

    private LogFormat(byte versionByte, int headerSize, KernelVersion from, KernelVersion to, LogFormatHeaderParser headerParser) {
        this.versionByte = versionByte;
        this.headerSize = headerSize;
        this.fromKernelVersion = from;
        this.toKernelVersion = to;
        this.headerParser = headerParser;
    }

    public byte getVersionByte() {
        return this.versionByte;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogHeader parseHeader(ByteBuffer buffer, boolean strict, Path sourceFile) throws IOException {
        ByteOrder originalOrder = buffer.order();
        try {
            buffer.order(ByteOrder.BIG_ENDIAN);
            if (LogFormat.checkUnderflow(buffer, 8, strict, sourceFile)) {
                LogHeader logHeader = null;
                return logHeader;
            }
            long encodedLogVersions = buffer.getLong();
            if (encodedLogVersions == 0L) {
                LogHeader logHeader = null;
                return logHeader;
            }
            byte logFormatVersion = LogFormat.decodeLogFormatVersion(encodedLogVersions);
            long logVersion = LogFormat.decodeLogVersion(encodedLogVersions);
            LogFormat logFormat = BY_VERSION_BYTE[logFormatVersion];
            if (logFormat == null) {
                throw new IOException("Unrecognized transaction log format version: " + logFormatVersion);
            }
            if (LogFormat.checkUnderflow(buffer, logFormat.headerSize - 8, strict, sourceFile)) {
                LogHeader logHeader = null;
                return logHeader;
            }
            LogHeader logHeader = logFormat.headerParser.parse(logVersion, buffer);
            return logHeader;
        }
        finally {
            buffer.order(originalOrder);
        }
    }

    private static void buildKernelToFormatMap() {
        LogFormat[] logFormats = LogFormat.values();
        Arrays.sort(logFormats, Comparator.comparingInt(LogFormat::getVersionByte));
        KernelVersion[] kernelVersions = KernelVersion.values();
        Arrays.sort(kernelVersions, Comparator.comparingInt(KernelVersion::version));
        int i = 0;
        for (KernelVersion kernelVersion : kernelVersions) {
            if (kernelVersion == KernelVersion.GLORIOUS_FUTURE) continue;
            while (kernelVersion.isGreaterThan(logFormats[i].toKernelVersion)) {
                ++i;
            }
            KERNEL_VERSION_TO_LOG_FORMAT.put(kernelVersion, logFormats[i]);
        }
    }

    public static LogFormat fromKernelVersion(KernelVersion kernelVersion) {
        return KERNEL_VERSION_TO_LOG_FORMAT.get(kernelVersion);
    }

    private static boolean checkUnderflow(ByteBuffer buffer, int require, boolean strict, Path fileForAdditionalErrorInformationOrNull) throws IncompleteLogHeaderException {
        if (buffer.remaining() < require) {
            if (strict) {
                if (fileForAdditionalErrorInformationOrNull != null) {
                    throw new IncompleteLogHeaderException(fileForAdditionalErrorInformationOrNull, buffer.remaining(), require);
                }
                throw new IncompleteLogHeaderException(buffer.remaining(), require);
            }
            return true;
        }
        return false;
    }

    private static long decodeLogVersion(long encLogVersion) {
        return encLogVersion & 0xFFFFFFFFFFFFFFL;
    }

    private static byte decodeLogFormatVersion(long encLogVersion) {
        return (byte)(encLogVersion >> 56 & 0xFFL);
    }

    static {
        CURRENT_LOG_FORMAT_VERSION = LogFormat.V8.versionByte;
        CURRENT_FORMAT_LOG_HEADER_SIZE = LogFormat.V8.headerSize;
        KERNEL_VERSION_TO_LOG_FORMAT = new EnumMap(KernelVersion.class);
        int biggestHeader = 0;
        BY_VERSION_BYTE = new LogFormat[127];
        LogFormat[] logFormatArray = LogFormat.values();
        int n = logFormatArray.length;
        for (int i = 0; i < n; ++i) {
            LogFormat format;
            LogFormat.BY_VERSION_BYTE[format.versionByte] = format = logFormatArray[i];
            if (biggestHeader >= format.headerSize) continue;
            biggestHeader = format.headerSize;
        }
        BIGGEST_HEADER = biggestHeader;
        LogFormat.buildKernelToFormatMap();
    }

    private static interface LogFormatHeaderParser {
        public LogHeader parse(long var1, ByteBuffer var3) throws IOException;
    }
}

