/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.eclipse.collections.impl.map.mutable.primitive.ByteObjectHashMap;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.util.Preconditions;

public abstract class LogEntryParserSet {
    private final KernelVersion introductionVersion;
    private final ByteObjectHashMap<LogEntryParser> parsers = new ByteObjectHashMap();

    LogEntryParserSet(KernelVersion version) {
        this.introductionVersion = version;
    }

    public LogEntryParser select(byte type) {
        LogEntryParser parser = (LogEntryParser)this.parsers.get(type);
        if (parser == null) {
            throw new IllegalArgumentException("Unknown entry type " + type + " for version " + String.valueOf(this.introductionVersion));
        }
        return parser;
    }

    protected void register(LogEntryParser parser) {
        byte type = parser.type();
        Preconditions.checkState((!this.parsers.containsKey(type) ? 1 : 0) != 0, (String)("Already registered parser for type " + type));
        this.parsers.put(type, (Object)parser);
    }

    public KernelVersion getIntroductionVersion() {
        return this.introductionVersion;
    }
}

