/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.util.Objects;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.StoreId;

public class LogHeader {
    public static final int LOG_HEADER_VERSION_SIZE = 8;
    private final byte logFormatVersion;
    private final long logVersion;
    private final long lastCommittedTxId;
    private final StoreId storeId;
    private final LogPosition startPosition;

    public LogHeader(long logVersion, long lastCommittedTxId, StoreId storeId) {
        this(7, logVersion, lastCommittedTxId, storeId, 64L);
    }

    public LogHeader(byte logFormatVersion, long logVersion, long lastCommittedTxId, long headerSize) {
        this(logFormatVersion, logVersion, lastCommittedTxId, StoreId.UNKNOWN, headerSize);
    }

    public LogHeader(byte logFormatVersion, long logVersion, long lastCommittedTxId, StoreId storeId, long headerSize) {
        this.logFormatVersion = logFormatVersion;
        this.logVersion = logVersion;
        this.lastCommittedTxId = lastCommittedTxId;
        this.storeId = storeId;
        this.startPosition = new LogPosition(logVersion, headerSize);
    }

    public LogPosition getStartPosition() {
        return this.startPosition;
    }

    public byte getLogFormatVersion() {
        return this.logFormatVersion;
    }

    public long getLogVersion() {
        return this.logVersion;
    }

    public long getLastCommittedTxId() {
        return this.lastCommittedTxId;
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogHeader logHeader = (LogHeader)o;
        return this.logFormatVersion == logHeader.logFormatVersion && this.logVersion == logHeader.logVersion && this.lastCommittedTxId == logHeader.lastCommittedTxId && Objects.equals(this.storeId, logHeader.storeId) && Objects.equals(this.startPosition, logHeader.startPosition);
    }

    public int hashCode() {
        return Objects.hash(this.logFormatVersion, this.logVersion, this.lastCommittedTxId, this.storeId, this.startPosition);
    }

    public String toString() {
        return "LogHeader{logFormatVersion=" + this.logFormatVersion + ", logVersion=" + this.logVersion + ", lastCommittedTxId=" + this.lastCommittedTxId + ", storeId=" + this.storeId + ", startPosition=" + this.startPosition + "}";
    }
}

