/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.eclipse.collections.impl.map.mutable.primitive.ByteObjectHashMap;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.util.Preconditions;

public interface LogEntryParserSet {
    public LogEntryParser select(byte var1);

    public byte version();

    public static abstract class Adapter
    implements LogEntryParserSet {
        private final byte version;
        private final ByteObjectHashMap<LogEntryParser> parsers = new ByteObjectHashMap();

        Adapter(byte version) {
            this.version = version;
        }

        protected void register(LogEntryParser parser) {
            byte type = parser.type();
            Preconditions.checkState((!this.parsers.containsKey(type) ? 1 : 0) != 0, (String)("Already registered parser for type " + type));
            this.parsers.put(type, (Object)parser);
        }

        @Override
        public LogEntryParser select(byte type) {
            LogEntryParser parser = (LogEntryParser)this.parsers.get(type);
            if (parser == null) {
                throw new IllegalArgumentException("Unknown entry type " + type + " for version " + this.version);
            }
            return parser;
        }

        @Override
        public byte version() {
            return this.version;
        }
    }
}

