/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.fs.PositionableChannel;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParserSet;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.util.FeatureToggles;

public class VersionAwareLogEntryReader
implements LogEntryReader {
    private static final boolean VERIFY_CHECKSUM_CHAIN = FeatureToggles.flag(LogEntryReader.class, (String)"verifyChecksumChain", (boolean)false);
    private final LogEntryVersion selector;
    private final CommandReaderFactory commandReaderFactory;
    private final LogPositionMarker positionMarker;
    private final boolean verifyChecksumChain;
    private LogEntryParserSet parserSet = LogEntryVersion.LATEST;
    private int lastTxChecksum = -559063315;

    public VersionAwareLogEntryReader(CommandReaderFactory commandReaderFactory) {
        this(commandReaderFactory, true);
    }

    public VersionAwareLogEntryReader(CommandReaderFactory commandReaderFactory, boolean verifyChecksumChain) {
        this.selector = LogEntryVersion.INSTANCE;
        this.commandReaderFactory = commandReaderFactory;
        this.positionMarker = new LogPositionMarker();
        this.verifyChecksumChain = verifyChecksumChain;
    }

    @Override
    public LogEntry readLogEntry(ReadableClosablePositionAwareChecksumChannel channel) throws IOException {
        try {
            LogEntry entry;
            channel.getCurrentPosition(this.positionMarker);
            byte versionCode = channel.get();
            if (versionCode == 0) {
                if (!(channel instanceof PositionableChannel)) {
                    throw new IllegalStateException("Log reader expects positionable channel to be able to reset offset. Current channel: " + channel);
                }
                this.resetChannelPosition(channel);
                return null;
            }
            if (this.parserSet == null || this.parserSet.version() != versionCode) {
                this.parserSet = this.selector.select(versionCode);
                this.resetChannelPosition(channel);
                channel.beginChecksum();
                channel.get();
            }
            byte typeCode = channel.get();
            try {
                LogEntryParser entryReader = this.parserSet.select(typeCode);
                entry = entryReader.parse(versionCode, channel, this.positionMarker, this.commandReaderFactory);
            }
            catch (ReadPastEndException e) {
                throw e;
            }
            catch (Exception e) {
                LogPosition position = this.positionMarker.newPosition();
                Exceptions.withMessage((Throwable)e, (String)(e.getMessage() + ". At position " + position + " and entry version " + versionCode));
                Exceptions.throwIfInstanceOf((Throwable)e, UnsupportedLogVersionException.class);
                throw new IOException(e);
            }
            this.verifyChecksumChain(entry);
            return entry;
        }
        catch (ReadPastEndException e) {
            return null;
        }
    }

    private void verifyChecksumChain(LogEntry e) {
        if (VERIFY_CHECKSUM_CHAIN && this.verifyChecksumChain) {
            if (e instanceof LogEntryStart) {
                int previousChecksum = ((LogEntryStart)e).getPreviousChecksum();
                if (this.lastTxChecksum != -559063315 && previousChecksum != this.lastTxChecksum) {
                    throw new IllegalStateException("The checksum chain is broken. " + this.positionMarker);
                }
            } else if (e instanceof LogEntryCommit) {
                this.lastTxChecksum = ((LogEntryCommit)e).getChecksum();
            }
        }
    }

    private void resetChannelPosition(ReadableClosablePositionAwareChecksumChannel channel) throws IOException {
        channel.getCurrentPosition(this.positionMarker);
        PositionableChannel positionableChannel = (PositionableChannel)channel;
        positionableChannel.setCurrentPosition(this.positionMarker.getByteOffset() - 1L);
        channel.getCurrentPosition(this.positionMarker);
    }

    @Override
    public LogPosition lastPosition() {
        return this.positionMarker.newPosition();
    }
}

