/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.CommandReader;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public class ServiceLoadingCommandReaderFactory
implements CommandReaderFactory {
    private final IntObjectMap<CommandReader> readersByFormatId;

    public ServiceLoadingCommandReaderFactory() {
        this(Services.loadAll(CommandReader.class));
    }

    @VisibleForTesting
    ServiceLoadingCommandReaderFactory(Iterable<CommandReader> readers) {
        IntObjectHashMap readerByFormatId = new IntObjectHashMap();
        for (CommandReader reader : readers) {
            CommandReader prev = (CommandReader)readerByFormatId.put(reader.getFormatId(), (Object)reader);
            Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Command format %d support is declared by multiple readers: %s and %s", (Object[])new Object[]{reader.getFormatId(), reader, prev});
        }
        this.readersByFormatId = readerByFormatId.toImmutable();
        this.verifyLegacyVersionsSupport();
    }

    private void verifyLegacyVersionsSupport() {
        LogEntryVersion[] versions;
        for (LogEntryVersion version : versions = LogEntryVersion.values()) {
            if (this.readersByFormatId.get((int)version.version()) == null) {
                throw new AssertionError((Object)("Version " + version + " not handled"));
            }
        }
    }

    public CommandReader get(int formatId) {
        CommandReader reader = (CommandReader)this.readersByFormatId.get(formatId);
        if (reader == null) {
            throw new IllegalArgumentException("Unsupported command format [id=" + formatId + "]");
        }
        return reader;
    }
}

