/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.map.mutable.primitive.ByteObjectHashMap;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParsersV2_3;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParsersV4_0;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;

public enum LogEntryVersion {
    V3_0_10(-10, LogEntryParsersV2_3.class),
    V4_0(1, LogEntryParsersV4_0.class);

    public static final LogEntryVersion LATEST_VERSION;
    private static final byte LOWEST_VERSION;
    private static final LogEntryVersion[] ALL;
    private static final ByteObjectHashMap<LogEntryVersion> LOOKUP_BY_VERSION;
    private final byte version;
    private final LogEntryParser[] entryTypes;

    private LogEntryVersion(byte version, Class<? extends Enum<? extends LogEntryParser>> cls) {
        this.entryTypes = new LogEntryParser[LogEntryVersion.highestCode(cls) + 1];
        for (Enum<? extends LogEntryParser> parser : cls.getEnumConstants()) {
            LogEntryParser candidate;
            this.entryTypes[candidate.byteCode()] = candidate = (LogEntryParser)((Object)parser);
        }
        this.version = version;
    }

    public byte version() {
        return this.version;
    }

    public LogEntryParser entryParser(byte type) {
        LogEntryParser candidate;
        LogEntryParser logEntryParser = candidate = type >= 0 && type < this.entryTypes.length ? this.entryTypes[type] : null;
        if (candidate == null) {
            throw new IllegalArgumentException("Unknown entry type " + type + " for version " + this.version);
        }
        return candidate;
    }

    public static boolean moreRecentVersionExists(LogEntryVersion version) {
        return version.version < LogEntryVersion.LATEST_VERSION.version;
    }

    public static LogEntryVersion byVersion(byte version) {
        LogEntryVersion logEntryVersion = (LogEntryVersion)((Object)LOOKUP_BY_VERSION.get(version));
        if (logEntryVersion != null) {
            return logEntryVersion;
        }
        byte latestVersion = LATEST_VERSION.version();
        if (version > latestVersion) {
            throw new UnsupportedLogVersionException(String.format("Transaction logs contains entries with prefix %d, and the highest supported prefix is %d. This indicates that the log files originates from a newer version of neo4j.", version, latestVersion));
        }
        throw new UnsupportedLogVersionException(String.format("Transaction logs contains entries with prefix %d, and the lowest supported prefix is %d. This indicates that the log files originates from an older version of neo4j, which we don't support migrations from.", version, LOWEST_VERSION));
    }

    private static int highestCode(Class<? extends Enum<? extends LogEntryParser>> cls) {
        int highestCode = 0;
        for (Enum<? extends LogEntryParser> parser : cls.getEnumConstants()) {
            LogEntryParser candidate = (LogEntryParser)((Object)parser);
            highestCode = Math.max(highestCode, candidate.byteCode());
        }
        return highestCode;
    }

    static {
        ALL = LogEntryVersion.values();
        LOOKUP_BY_VERSION = new ByteObjectHashMap();
        for (LogEntryVersion version : ALL) {
            LOOKUP_BY_VERSION.put(version.version(), (Object)version);
        }
        MutableByteSet keys = LOOKUP_BY_VERSION.keySet();
        LOWEST_VERSION = keys.min();
        LATEST_VERSION = (LogEntryVersion)((Object)LOOKUP_BY_VERSION.get(keys.max()));
    }
}

