/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;

public class TransactionLogFilesHelper {
    public static final String DEFAULT_NAME = "neostore.transaction.db";
    private static final String REGEX_DEFAULT_NAME = "neostore\\.transaction\\.db";
    static final FilenameFilter DEFAULT_FILENAME_FILTER = new LogicalLogFilenameFilter("neostore\\.transaction\\.db");
    private static final String VERSION_SUFFIX = ".";
    private static final String REGEX_VERSION_SUFFIX = "\\.";
    private static final File[] EMPTY_FILES_ARRAY = new File[0];
    private final File logBaseName;
    private final FilenameFilter logFileFilter;
    private final FileSystemAbstraction fileSystem;

    public TransactionLogFilesHelper(FileSystemAbstraction fileSystem, File directory) {
        this(fileSystem, directory, DEFAULT_NAME);
    }

    public TransactionLogFilesHelper(FileSystemAbstraction fileSystem, File directory, String name) {
        this.fileSystem = fileSystem;
        this.logBaseName = new File(directory, name);
        this.logFileFilter = new LogicalLogFilenameFilter(name);
    }

    public File getLogFileForVersion(long version) {
        return new File(this.logBaseName.getPath() + VERSION_SUFFIX + version);
    }

    public long getLogVersion(File historyLogFile) {
        String historyLogFilename = historyLogFile.getName();
        int index = historyLogFilename.lastIndexOf(VERSION_SUFFIX);
        if (index == -1) {
            throw new RuntimeException("Invalid log file '" + historyLogFilename + "'");
        }
        return Long.parseLong(historyLogFilename.substring(index + VERSION_SUFFIX.length()));
    }

    FilenameFilter getLogFilenameFilter() {
        return this.logFileFilter;
    }

    public File[] getLogFiles() {
        File[] files = this.fileSystem.listFiles(this.logBaseName.getParentFile(), this.getLogFilenameFilter());
        if (files == null) {
            return EMPTY_FILES_ARRAY;
        }
        return files;
    }

    public void accept(LogVersionVisitor visitor) {
        for (File file : this.getLogFiles()) {
            visitor.visit(file, this.getLogVersion(file));
        }
    }

    private static final class LogicalLogFilenameFilter
    implements FilenameFilter {
        private final Pattern logFilenamePattern;

        LogicalLogFilenameFilter(String name) {
            this.logFilenamePattern = Pattern.compile(name + "\\..*");
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.logFilenamePattern.matcher(name).matches();
        }
    }
}

