/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeReadChannel;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public class TailUtils {
    private TailUtils() {
    }

    public static void checkTail(ReadableLogPositionAwareChannel channel, LogPosition currentLogPosition, Exception e) throws IOException {
        TailUtils.checkTail(channel, currentLogPosition, (int)ByteUnit.kibiBytes((long)16L), true, e);
    }

    public static void checkSmallChunkOfTail(ReadableLogPositionAwareChannel channel, LogPosition currentLogPosition) throws IOException {
        TailUtils.checkTail(channel, currentLogPosition, (int)ByteUnit.kibiBytes((long)1L), false, null);
    }

    private static void checkTail(ReadableLogPositionAwareChannel channel, LogPosition currentLogPosition, int bufferSize, boolean checkToEnd, Exception e) throws IOException {
        byte[] zeroArray = new byte[bufferSize];
        try (HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(bufferSize, ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            ByteBuffer buffer = scopedBuffer.getBuffer();
            boolean endReached = false;
            do {
                try {
                    if (channel instanceof EnvelopeReadChannel) {
                        EnvelopeReadChannel envelopeReadChannel = (EnvelopeReadChannel)channel;
                        envelopeReadChannel.directRead(buffer);
                    } else {
                        channel.read(buffer);
                    }
                }
                catch (ReadPastEndException ee) {
                    endReached = true;
                }
                buffer.flip();
                if (Arrays.mismatch(buffer.array(), 0, buffer.limit(), zeroArray, 0, buffer.limit()) == -1) continue;
                throw new IllegalStateException("Failure to read transaction log file number " + currentLogPosition.getLogVersion() + ". Unreadable bytes are encountered after last readable position.", e);
            } while (!endReached && checkToEnd);
        }
    }
}

