/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogBinarySearch;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogChannelContext;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogsRepository;
import org.neo4j.memory.MemoryTracker;

class LogFileBinarySearch
implements LogBinarySearch.BinarySearchReader {
    private final LogsRepository logsRepository;
    private final int numFiles;
    private final long startFileVersion;
    private final MemoryTracker memoryTracker;

    public LogFileBinarySearch(LogsRepository logsRepository, long startFileVersion, long numFiles, MemoryTracker memoryTracker) {
        this.logsRepository = logsRepository;
        this.numFiles = (int)numFiles;
        this.startFileVersion = startFileVersion;
        this.memoryTracker = memoryTracker;
    }

    @Override
    public int size() {
        return this.numFiles;
    }

    @Override
    public long get(int index) {
        return this.startFileVersion + (long)index;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int compare(long version, long targetEntryIndex) {
        try (LogChannelContext<StoreChannel> logChannelContext = this.logsRepository.openReadChannel(version);){
            LogHeader logHeader = LogHeaderReader.readLogHeader((ReadableByteChannel)logChannelContext.channel(), true, null, this.memoryTracker);
            if (logHeader != null) {
                long lastAppendIndex = logHeader.getLastAppendIndex();
                if (lastAppendIndex < targetEntryIndex) {
                    int n = -1;
                    return n;
                }
                int n = 1;
                return n;
            }
            int n = 1;
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

