/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v57;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryRollback;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class RollbackLogEntrySerializerV5_7
extends LogEntrySerializer<LogEntryRollback> {
    public RollbackLogEntrySerializerV5_7() {
        super((byte)12);
    }

    @Override
    public LogEntryRollback parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory, MemoryTracker memoryTracker) throws IOException {
        long transactionId = channel.getLong();
        long timeWritten = channel.getLong();
        int checksum = channel.endChecksumAndValidate();
        return new LogEntryRollback(version, transactionId, timeWritten, checksum);
    }

    @Override
    public int write(WritableChannel channel, LogEntryRollback logEntry) throws IOException {
        channel.beginChecksumForWriting();
        RollbackLogEntrySerializerV5_7.writeLogEntryHeader(logEntry.kernelVersion(), (byte)12, channel);
        channel.putLong(logEntry.getTransactionId()).putLong(logEntry.getTimeWritten());
        return channel.putChecksum();
    }
}

