/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.util.EnumMap;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSet;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSetV2025_05;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSetV2_3;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSetV4_0;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSetV4_2;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSetV5_0;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSetV5_20;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSetV5_22;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSetV5_7;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSetVGloriousFuture;

public class LogEntrySerializationSets {
    private static final EnumMap<KernelVersion, LogEntrySerializationSet> SERIALIZATION_SETS = new EnumMap(KernelVersion.class);

    public static LogEntrySerializationSet serializationSet(KernelVersion version, BinarySupportedKernelVersions binarySupportedKernelVersions) {
        LogEntrySerializationSet parserSet = SERIALIZATION_SETS.get(version);
        if (parserSet == null) {
            if (version == KernelVersion.GLORIOUS_FUTURE && binarySupportedKernelVersions.latestSupportedIsAtLeast(version)) {
                return new LogEntrySerializationSetVGloriousFuture();
            }
            throw new IllegalArgumentException(String.format("No log entries version matching %s", version));
        }
        return parserSet;
    }

    static {
        SERIALIZATION_SETS.put(KernelVersion.V2_3, new LogEntrySerializationSetV2_3());
        SERIALIZATION_SETS.put(KernelVersion.V4_0, new LogEntrySerializationSetV4_0());
        SERIALIZATION_SETS.put(KernelVersion.V4_2, new LogEntrySerializationSetV4_2());
        SERIALIZATION_SETS.put(KernelVersion.V4_3_D4, new LogEntrySerializationSetV4_2(KernelVersion.V4_3_D4));
        SERIALIZATION_SETS.put(KernelVersion.V4_4, new LogEntrySerializationSetV4_2(KernelVersion.V4_4));
        SERIALIZATION_SETS.put(KernelVersion.V5_0, new LogEntrySerializationSetV5_0());
        SERIALIZATION_SETS.put(KernelVersion.V5_7, new LogEntrySerializationSetV5_7());
        SERIALIZATION_SETS.put(KernelVersion.V5_8, new LogEntrySerializationSetV5_7(KernelVersion.V5_8));
        SERIALIZATION_SETS.put(KernelVersion.V5_9, new LogEntrySerializationSetV5_7(KernelVersion.V5_9));
        SERIALIZATION_SETS.put(KernelVersion.V5_10, new LogEntrySerializationSetV5_7(KernelVersion.V5_10));
        SERIALIZATION_SETS.put(KernelVersion.V5_11, new LogEntrySerializationSetV5_7(KernelVersion.V5_11));
        SERIALIZATION_SETS.put(KernelVersion.V5_12, new LogEntrySerializationSetV5_7(KernelVersion.V5_12));
        SERIALIZATION_SETS.put(KernelVersion.V5_13, new LogEntrySerializationSetV5_7(KernelVersion.V5_13));
        SERIALIZATION_SETS.put(KernelVersion.V5_14, new LogEntrySerializationSetV5_7(KernelVersion.V5_14));
        SERIALIZATION_SETS.put(KernelVersion.V5_15, new LogEntrySerializationSetV5_7(KernelVersion.V5_15));
        SERIALIZATION_SETS.put(KernelVersion.V5_18, new LogEntrySerializationSetV5_7(KernelVersion.V5_18));
        SERIALIZATION_SETS.put(KernelVersion.V5_19, new LogEntrySerializationSetV5_7(KernelVersion.V5_19));
        SERIALIZATION_SETS.put(KernelVersion.V5_20, new LogEntrySerializationSetV5_20());
        SERIALIZATION_SETS.put(KernelVersion.V5_22, new LogEntrySerializationSetV5_22());
        SERIALIZATION_SETS.put(KernelVersion.V5_23, new LogEntrySerializationSetV5_22(KernelVersion.V5_23));
        SERIALIZATION_SETS.put(KernelVersion.V5_25, new LogEntrySerializationSetV5_22(KernelVersion.V5_25));
        SERIALIZATION_SETS.put(KernelVersion.V2025_04, new LogEntrySerializationSetV5_22(KernelVersion.V2025_04));
        SERIALIZATION_SETS.put(KernelVersion.V2025_05, new LogEntrySerializationSetV2025_05());
        SERIALIZATION_SETS.put(KernelVersion.V2025_07, new LogEntrySerializationSetV2025_05(KernelVersion.V2025_07));
    }
}

