/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import org.neo4j.cursor.RawCursor;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogChannelContext;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogFileMetadata;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogsRepository;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public class LogFilesMetadata
implements RawCursor<LogFileMetadata, IOException> {
    private final LogsRepository logsRepository;
    private final long[] versions;
    private int currentVersionIndex = -1;
    private LogFileMetadata nextMetadata = null;
    private final boolean reversed;

    LogFilesMetadata(LogsRepository logsRepository) throws IOException {
        this(logsRepository, false);
    }

    LogFilesMetadata(LogsRepository logsRepository, boolean reversed) throws IOException {
        this.logsRepository = logsRepository;
        this.versions = logsRepository.logVersions(reversed);
        this.reversed = reversed;
    }

    public boolean next() throws IOException {
        if (this.versions.length != 0 && this.currentVersionIndex < this.versions.length) {
            this.setNext();
            return this.nextMetadata != null;
        }
        return false;
    }

    public LogFileMetadata get() {
        return this.nextMetadata;
    }

    public void close() throws IOException {
    }

    private void setNext() throws IOException {
        this.nextMetadata = null;
        if (++this.currentVersionIndex != this.versions.length) {
            long version = this.versions[this.currentVersionIndex];
            try (LogChannelContext<StoreChannel> logChannel = this.logsRepository.openReadChannel(version);){
                Path currentPath = logChannel.path();
                LogHeader logHeader = LogHeaderReader.readLogHeader((ReadableByteChannel)logChannel.channel(), true, null, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                if (logHeader != null) {
                    this.nextMetadata = new LogFileMetadata(logHeader, version, currentPath);
                } else if (this.reversed) {
                    this.setNext();
                }
            }
        }
    }
}

