/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v522;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.v522.LogEntryDetachedCheckpointV5_22;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdSerialization;
import org.neo4j.storageengine.api.TransactionId;

public class DetachedCheckpointLogEntrySerializerV5_22
extends LogEntrySerializer<LogEntryDetachedCheckpointV5_22> {
    public static final int RECORD_LENGTH_BYTES = 232;
    public static final int MAX_DESCRIPTION_LENGTH = 75;

    public static int checkPointRecordSizeDependingOnVersion(KernelVersion version) {
        if (version.isLessThan(KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED)) {
            return 232;
        }
        return 258;
    }

    public DetachedCheckpointLogEntrySerializerV5_22() {
        super((byte)9);
    }

    @Override
    public LogEntryDetachedCheckpointV5_22 parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory, MemoryTracker memoryTracker) throws IOException {
        LogPosition checkpointedLogPosition = new LogPosition(channel.getLong(), channel.getLong());
        LogPosition oldestNotCompletedPosition = new LogPosition(channel.getLong(), channel.getLong());
        long checkpointTimeMillis = channel.getLong();
        byte[] storeIdBuffer = new byte[64];
        channel.get(storeIdBuffer, storeIdBuffer.length);
        StoreId storeId = StoreIdSerialization.deserializeWithFixedSize((ByteBuffer)ByteBuffer.wrap(storeIdBuffer));
        TransactionId transactionId = new TransactionId(channel.getLong(), channel.getLong(), KernelVersion.getForVersion((byte)channel.get()), channel.getInt(), channel.getLong(), channel.getLong());
        long appendIndex = channel.getLong();
        short reasonBytesLength = channel.getShort();
        byte[] bytes = new byte[75];
        channel.get(bytes, 75);
        String reason = new String(bytes, 0, (int)reasonBytesLength, StandardCharsets.UTF_8);
        channel.endChecksumAndValidate();
        return new LogEntryDetachedCheckpointV5_22(version, transactionId, appendIndex, oldestNotCompletedPosition, checkpointedLogPosition, checkpointTimeMillis, storeId, reason);
    }

    @Override
    public int write(WritableChannel channel, LogEntryDetachedCheckpointV5_22 logEntry) throws IOException {
        channel.beginChecksumForWriting();
        DetachedCheckpointLogEntrySerializerV5_22.writeLogEntryHeader(logEntry.kernelVersion(), (byte)9, channel);
        byte[] storeIdBuffer = new byte[64];
        StoreIdSerialization.serializeWithFixedSize((StoreId)logEntry.getStoreId(), (ByteBuffer)ByteBuffer.wrap(storeIdBuffer));
        byte[] reasonBytes = logEntry.getReason().getBytes();
        short length = Numbers.safeCastIntToShort((int)Math.min(reasonBytes.length, 75));
        byte[] descriptionBytes = new byte[75];
        System.arraycopy(reasonBytes, 0, descriptionBytes, 0, length);
        LogPosition checkpointedLogPosition = logEntry.getCheckpointedLogPosition();
        LogPosition oldestNotCompletedPosition = logEntry.getOldestNotCompletedPosition();
        TransactionId transactionId = logEntry.getTransactionId();
        channel.putLong(checkpointedLogPosition.getLogVersion()).putLong(checkpointedLogPosition.getByteOffset()).putLong(oldestNotCompletedPosition.getLogVersion()).putLong(oldestNotCompletedPosition.getByteOffset()).putLong(logEntry.getCheckpointTime()).put(storeIdBuffer, storeIdBuffer.length).putLong(transactionId.id()).putLong(transactionId.appendIndex()).put(transactionId.kernelVersion().version()).putInt(transactionId.checksum()).putLong(transactionId.commitTimestamp()).putLong(transactionId.consensusIndex()).putLong(logEntry.getLastAppendIndex()).putShort(length).put(descriptionBytes, descriptionBytes.length);
        return channel.putChecksum();
    }
}

