/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSet;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSets;
import org.neo4j.kernel.impl.transaction.log.entry.TailUtils;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.enveloped.IncompleteEnvelopeReadException;
import org.neo4j.kernel.impl.transaction.log.enveloped.InvalidLogEnvelopeReadException;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class VersionAwareLogEntryReader
implements LogEntryReader {
    private final CommandReaderFactory commandReaderFactory;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;
    private final LogPositionMarker positionMarker;
    private final MemoryTracker memoryTracker;
    private boolean brokenLastEntry;
    private LogEntrySerializationSet parserSet;

    public VersionAwareLogEntryReader(CommandReaderFactory commandReaderFactory, BinarySupportedKernelVersions binarySupportedKernelVersions, MemoryTracker memoryTracker) {
        this.commandReaderFactory = commandReaderFactory;
        this.positionMarker = new LogPositionMarker();
        this.binarySupportedKernelVersions = binarySupportedKernelVersions;
        this.memoryTracker = memoryTracker;
    }

    @Override
    public LogEntry readLogEntry(ReadableLogPositionAwareChannel channel) throws IOException {
        try {
            byte versionCode = channel.markAndGetVersion(this.positionMarker);
            if (versionCode == 0) {
                TailUtils.checkSmallChunkOfTail(channel, channel.getCurrentLogPosition());
                channel.position(this.positionMarker.getByteOffset());
                return null;
            }
            this.updateParserSet(channel, versionCode);
            byte typeCode = channel.get();
            return this.readEntry(channel, versionCode, typeCode, this.memoryTracker);
        }
        catch (ReadPastEndException e) {
            return null;
        }
        catch (IllegalStateException | UnsupportedLogVersionException | InvalidLogEnvelopeReadException e) {
            throw e;
        }
        catch (IncompleteEnvelopeReadException e) {
            return this.brokenLastEntry();
        }
        catch (IOException | RuntimeException e) {
            LogPosition currentLogPosition = channel.getCurrentLogPosition();
            TailUtils.checkTail(channel, currentLogPosition, e);
            return this.brokenLastEntry();
        }
    }

    private LogEntry brokenLastEntry() throws IOException {
        this.brokenLastEntry = true;
        return null;
    }

    public boolean hasBrokenLastEntry() {
        return this.brokenLastEntry;
    }

    private void updateParserSet(ReadableLogPositionAwareChannel channel, byte versionCode) throws IOException {
        if (this.parserSet != null && this.parserSet.getIntroductionVersion().version() == versionCode) {
            return;
        }
        try {
            KernelVersion kernelVersion = KernelVersion.getForVersion((byte)versionCode);
            this.parserSet = LogEntrySerializationSets.serializationSet(kernelVersion, this.binarySupportedKernelVersions);
            if (kernelVersion.isLessThan(KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED)) {
                this.rewindOneByte(channel);
                channel.beginChecksum();
                channel.get();
            }
        }
        catch (IllegalArgumentException e) {
            throw UnsupportedLogVersionException.unsupported(this.binarySupportedKernelVersions, versionCode);
        }
    }

    private void rewindOneByte(ReadableLogPositionAwareChannel channel) throws IOException {
        channel.position(channel.position() - 1L);
        channel.getCurrentLogPosition(this.positionMarker);
    }

    private LogEntry readEntry(ReadableLogPositionAwareChannel channel, byte versionCode, byte typeCode, MemoryTracker memoryTracker) throws IOException {
        try {
            return this.parserSet.select(typeCode).parse(this.parserSet.getIntroductionVersion(), this.parserSet.wrap(channel), this.positionMarker, this.commandReaderFactory, memoryTracker);
        }
        catch (ReadPastEndException | IncompleteEnvelopeReadException e) {
            throw e;
        }
        catch (Exception e) {
            LogPosition position = this.positionMarker.newPosition();
            String message = e.getMessage() + ". At position " + String.valueOf(position) + " and entry version " + versionCode;
            if (e instanceof UnsupportedLogVersionException) {
                throw new UnsupportedLogVersionException(versionCode, message, e);
            }
            throw new IOException(message, e);
        }
    }

    @Override
    public LogPosition lastPosition() {
        return this.positionMarker.newPosition();
    }
}

