/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.eclipse.collections.impl.map.mutable.primitive.ByteObjectHashMap;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.util.Preconditions;

public abstract class LogEntrySerializationSet {
    private final KernelVersion introductionVersion;
    private final ByteObjectHashMap<LogEntrySerializer<? extends LogEntry>> serializers = new ByteObjectHashMap();

    LogEntrySerializationSet(KernelVersion version) {
        this.introductionVersion = version;
    }

    public LogEntrySerializer<LogEntry> select(byte type) {
        LogEntrySerializer parser = (LogEntrySerializer)this.serializers.get(type);
        if (parser == null) {
            throw new IllegalArgumentException("Unknown entry type " + type + " for version " + String.valueOf(this.introductionVersion));
        }
        return parser;
    }

    public void serialize(WritableChannel channel, Iterable<StorageCommand> commands, KernelVersion kernelVersion) throws IOException {
        for (StorageCommand storageCommand : commands) {
            assert (storageCommand.kernelVersion() == kernelVersion) : "Command serialization KernelVersion %s does not match tx KernelVersion %s".formatted(storageCommand.kernelVersion(), kernelVersion);
            LogEntrySerializer.writeLogEntryHeader(kernelVersion, (byte)3, channel);
            storageCommand.serialize(channel);
        }
    }

    protected void register(LogEntrySerializer<? extends LogEntry> parser) {
        this.register(parser, false);
    }

    protected void register(LogEntrySerializer<? extends LogEntry> parser, boolean override) {
        byte type = parser.type();
        if (override) {
            Preconditions.checkState((boolean)this.serializers.containsKey(type), (String)("No serializer to override for type " + type));
        } else {
            Preconditions.checkState((!this.serializers.containsKey(type) ? 1 : 0) != 0, (String)("Already registered serializer for type " + type));
        }
        this.serializers.put(type, parser);
    }

    public KernelVersion getIntroductionVersion() {
        return this.introductionVersion;
    }

    public abstract ReadableChannel wrap(ReadableChannel var1);
}

