/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v202505;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.BadLogEntryException;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.v202505.LogEntryStartV2025_05;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class StartLogEntrySerializerV2025_05
extends LogEntrySerializer<LogEntryStartV2025_05> {
    public StartLogEntrySerializerV2025_05() {
        super((byte)1);
    }

    @Override
    public LogEntryStartV2025_05 parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory, MemoryTracker memoryTracker) throws IOException {
        long timeWritten = channel.getLong();
        long latestCommittedTxWhenStarted = channel.getLong();
        long appendIndex = channel.getAppendIndex();
        int additionalHeaderLength = channel.getInt();
        if (additionalHeaderLength > 8) {
            throw new BadLogEntryException("Additional header length limit(8) exceeded. Parsed length is " + additionalHeaderLength);
        }
        byte[] additionalHeader = new byte[additionalHeaderLength];
        channel.get(additionalHeader, additionalHeaderLength);
        return new LogEntryStartV2025_05(version, timeWritten, latestCommittedTxWhenStarted, appendIndex, additionalHeader);
    }

    @Override
    public int write(WritableChannel channel, LogEntryStartV2025_05 logEntry) throws IOException {
        channel.beginChecksumForWriting();
        StartLogEntrySerializerV2025_05.writeLogEntryHeader(logEntry.kernelVersion(), (byte)1, channel);
        byte[] additionalHeaderData = logEntry.getAdditionalHeader();
        channel.putLong(logEntry.getTimeWritten()).putLong(logEntry.getLastCommittedTxWhenTransactionStarted()).putAppendIndex(logEntry.getAppendIndex()).putInt(additionalHeaderData.length).put(additionalHeaderData, additionalHeaderData.length);
        return 0;
    }
}

