/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.enveloped.PruneStrategy;

class LogPruningBySizeStrategy
implements PruneStrategy {
    private final FileSystemAbstraction fs;
    private final long pruneSizeThreshold;

    LogPruningBySizeStrategy(FileSystemAbstraction fs, long pruneSizeThreshold) {
        this.fs = fs;
        this.pruneSizeThreshold = pruneSizeThreshold;
    }

    @Override
    public PruneStrategy.PruneConstraint newConstraint(long currentEntry, long currentOffset, Path currentLogFile) {
        return new LogPruningBySize(this.fs, this.pruneSizeThreshold, currentOffset);
    }

    private static class LogPruningBySize
    implements PruneStrategy.PruneConstraint {
        private final FileSystemAbstraction fs;
        private long remainingBytes;

        LogPruningBySize(FileSystemAbstraction fs, long pruneSizeThreshold, long startOffset) {
            this.fs = fs;
            this.remainingBytes = pruneSizeThreshold - startOffset;
        }

        @Override
        public boolean shouldPrune(Path path) throws IOException {
            if (!this.fs.fileExists(path)) {
                throw new IllegalArgumentException("Can't get size for non-existing file: " + String.valueOf(path));
            }
            boolean shouldPrune = this.remainingBytes <= 0L;
            this.remainingBytes -= this.fs.getFileSize(path);
            return shouldPrune;
        }
    }
}

