/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import java.io.IOException;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.internal.nativeimpl.NativeCallResult;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.OutOfDiskSpaceException;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogChannelContext;

public class LogFilesPreAllocator {
    private final NativeAccess nativeAccess;

    public LogFilesPreAllocator(NativeAccess nativeAccess) {
        this.nativeAccess = nativeAccess;
    }

    public LogFilesPreAllocator() {
        this(NativeAccessProvider.getNativeAccess());
    }

    void preAllocateLogFile(LogChannelContext<StoreChannel> logChannelCtx, long fileSize) throws IOException {
        if (!this.nativeAccess.isAvailable()) {
            return;
        }
        if (logChannelCtx.channel().size() != 0L) {
            return;
        }
        NativeCallResult result = this.nativeAccess.tryPreallocateSpace(logChannelCtx.channel().getFileDescriptor(), fileSize);
        if (result.isError()) {
            if (this.nativeAccess.errorTranslator().isOutOfDiskSpace(result)) {
                throw new OutOfDiskSpaceException("System is out of disk space for log file at: " + String.valueOf(logChannelCtx.path()) + ". Requested file size: " + fileSize + ". Call error: " + String.valueOf(result));
            }
            throw new IOException("Fail to preallocate additional space for log file at: " + String.valueOf(logChannelCtx.path()) + ". Requested file size: " + fileSize + ". Call error: " + String.valueOf(result));
        }
    }
}

