/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v520;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.v520.LogEntryRollbackV5_20;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class RollbackLogEntrySerializerV5_20
extends LogEntrySerializer<LogEntryRollbackV5_20> {
    public RollbackLogEntrySerializerV5_20() {
        super((byte)12);
    }

    @Override
    public LogEntryRollbackV5_20 parse(KernelVersion version, ReadableChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory, MemoryTracker memoryTracker) throws IOException {
        long transactionId = channel.getLong();
        long timeWritten = channel.getLong();
        long appendIndex = channel.getAppendIndex();
        int checksum = channel.endChecksumAndValidate();
        return new LogEntryRollbackV5_20(version, transactionId, appendIndex, timeWritten, checksum);
    }

    @Override
    public int write(WritableChannel channel, LogEntryRollbackV5_20 logEntry) throws IOException {
        channel.beginChecksumForWriting();
        RollbackLogEntrySerializerV5_20.writeLogEntryHeader(logEntry.kernelVersion(), (byte)12, channel);
        channel.putLong(logEntry.getTransactionId()).putLong(logEntry.getTimeWritten()).putAppendIndex(logEntry.getAppendIndex());
        return channel.putChecksum();
    }
}

