/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v50;

import java.util.Objects;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractDetachedCheckpointLogEntry;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.string.Mask;

public class LogEntryDetachedCheckpointV5_0
extends AbstractDetachedCheckpointLogEntry {
    private final TransactionId transactionId;
    private final boolean consensusIndexInCheckpoint;

    public LogEntryDetachedCheckpointV5_0(KernelVersion kernelVersion, TransactionId transactionId, LogPosition checkpointedLogPosition, long checkpointMillis, StoreId storeId, String reason) {
        this(kernelVersion, transactionId, checkpointedLogPosition, checkpointMillis, storeId, reason, true);
    }

    public LogEntryDetachedCheckpointV5_0(KernelVersion kernelVersion, TransactionId transactionId, LogPosition logPosition, long checkpointMillis, StoreId storeId, String reason, boolean consensusIndexInCheckpoint) {
        super(kernelVersion, logPosition, checkpointMillis, storeId, reason);
        this.transactionId = transactionId;
        this.consensusIndexInCheckpoint = consensusIndexInCheckpoint;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryDetachedCheckpointV5_0 that = (LogEntryDetachedCheckpointV5_0)o;
        return this.checkpointTime == that.checkpointTime && Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.checkpointedLogPosition, that.checkpointedLogPosition) && Objects.equals(this.storeId, that.storeId) && this.kernelVersion() == that.kernelVersion() && Objects.equals(this.reason, that.reason);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.kernelVersion(), this.transactionId, this.checkpointedLogPosition, this.checkpointTime, this.storeId, this.reason);
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public boolean consensusIndexInCheckpoint() {
        return this.consensusIndexInCheckpoint;
    }

    @Override
    public String toString(Mask mask) {
        return "LogEntryDetachedCheckpointV5_0{transactionId=" + String.valueOf(this.transactionId) + ", logPosition=" + String.valueOf(this.checkpointedLogPosition) + ", checkpointTime=" + this.checkpointTime + ", storeId=" + String.valueOf(this.storeId) + ", reason='" + this.reason + "', version=" + String.valueOf(this.kernelVersion()) + "}";
    }
}

