/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.memory.MemoryTracker;

public final class LogHeaderReader {
    private LogHeaderReader() {
    }

    public static LogHeader readLogHeader(FileSystemAbstraction fileSystem, Path file, MemoryTracker memoryTracker) throws IOException {
        return LogHeaderReader.readLogHeader(fileSystem, file, true, memoryTracker);
    }

    public static LogHeader readLogHeader(FileSystemAbstraction fileSystem, Path file, boolean strict, MemoryTracker memoryTracker) throws IOException {
        try (StoreChannel channel = fileSystem.read(file);){
            LogHeader logHeader = LogHeaderReader.readLogHeader((ReadableByteChannel)channel, strict, file, memoryTracker);
            return logHeader;
        }
    }

    public static LogHeader readLogHeader(ReadableByteChannel channel, boolean strict, Path additionalErrorInformation, MemoryTracker memoryTracker) throws IOException {
        try (NativeScopedBuffer scopedBuffer = new NativeScopedBuffer(LogFormat.BIGGEST_HEADER, ByteOrder.BIG_ENDIAN, memoryTracker);){
            ByteBuffer buffer = scopedBuffer.getBuffer();
            LogHeader logHeader = LogHeaderReader.readLogHeader(buffer, channel, strict, additionalErrorInformation);
            return logHeader;
        }
    }

    private static LogHeader readLogHeader(ByteBuffer buffer, ReadableByteChannel channel, boolean strict, Path fileForAdditionalErrorInformationOrNull) throws IOException {
        buffer.clear();
        buffer.limit(LogFormat.BIGGEST_HEADER);
        channel.read(buffer);
        buffer.flip();
        LogHeader logHeader = LogFormat.parseHeader(buffer, strict, fileForAdditionalErrorInformationOrNull);
        if (logHeader != null && channel instanceof SeekableByteChannel) {
            SeekableByteChannel seekableByteChannel = (SeekableByteChannel)channel;
            seekableByteChannel.position(logHeader.getStartPosition().getByteOffset());
        }
        return logHeader;
    }

    static long decodeLogVersion(long encLogVersion) {
        return encLogVersion & 0xFFFFFFFFFFFFFFL;
    }

    static byte decodeLogFormatVersion(long encLogVersion) {
        return (byte)(encLogVersion >> 56 & 0xFFL);
    }
}

