/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.hashing.HashFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.Comparison;
import org.neo4j.values.Equality;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public abstract class Value
extends AnyValue {
    private static final Pattern MAP_PATTERN = Pattern.compile("\\{(.*)}");
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("(?:\\A|,)\\s*+(?<k>[a-z_A-Z]\\w*+)\\s*:\\s*(?<v>[^\\s,]+)");
    static final Pattern QUOTES_PATTERN = Pattern.compile("^[\"']|[\"']$");

    @Override
    public boolean equalTo(Object other) {
        return other instanceof Value && this.equals((Value)other);
    }

    public abstract boolean equals(Value var1);

    public boolean equals(byte[] x) {
        return false;
    }

    public boolean equals(short[] x) {
        return false;
    }

    public boolean equals(int[] x) {
        return false;
    }

    public boolean equals(long[] x) {
        return false;
    }

    public boolean equals(float[] x) {
        return false;
    }

    public boolean equals(double[] x) {
        return false;
    }

    public boolean equals(boolean x) {
        return false;
    }

    public boolean equals(boolean[] x) {
        return false;
    }

    public boolean equals(long x) {
        return false;
    }

    public boolean equals(double x) {
        return false;
    }

    public boolean equals(char x) {
        return false;
    }

    public boolean equals(String x) {
        return false;
    }

    public boolean equals(char[] x) {
        return false;
    }

    public boolean equals(String[] x) {
        return false;
    }

    public boolean equals(Geometry[] x) {
        return false;
    }

    public boolean equals(ZonedDateTime[] x) {
        return false;
    }

    public boolean equals(LocalDate[] x) {
        return false;
    }

    public boolean equals(DurationValue[] x) {
        return false;
    }

    public boolean equals(LocalDateTime[] x) {
        return false;
    }

    public boolean equals(LocalTime[] x) {
        return false;
    }

    public boolean equals(OffsetTime[] x) {
        return false;
    }

    @Override
    public Equality ternaryEquals(AnyValue other) {
        Value otherValue;
        assert (other != null) : "null values are not supported, use NoValue.NO_VALUE instead";
        if (other == Values.NO_VALUE) {
            return Equality.UNDEFINED;
        }
        if (other.isSequenceValue() && this.isSequenceValue()) {
            return ((SequenceValue)((Object)this)).ternaryEquality((SequenceValue)((Object)other));
        }
        if (Value.hasNaNOperand(this, other)) {
            return Equality.FALSE;
        }
        if (other instanceof Value && (otherValue = (Value)other).valueGroup() == this.valueGroup()) {
            if (this.ternaryUndefined() || otherValue.ternaryUndefined()) {
                return Equality.UNDEFINED;
            }
            return this.equals(otherValue) ? Equality.TRUE : Equality.FALSE;
        }
        return Equality.FALSE;
    }

    protected abstract int unsafeCompareTo(Value var1);

    Comparison unsafeTernaryCompareTo(Value other) {
        if (this.ternaryUndefined() || other.ternaryUndefined()) {
            return Comparison.UNDEFINED;
        }
        return Comparison.from(this.unsafeCompareTo(other));
    }

    boolean ternaryUndefined() {
        return false;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        this.writeTo((ValueWriter<E>)writer);
    }

    public abstract <E extends Exception> void writeTo(ValueWriter<E> var1) throws E;

    public abstract Object asObjectCopy();

    public Object asObject() {
        return this.asObjectCopy();
    }

    @Override
    public abstract String prettyPrint();

    @Override
    public abstract ValueRepresentation valueRepresentation();

    public final ValueGroup valueGroup() {
        return this.valueRepresentation().valueGroup();
    }

    public abstract NumberType numberType();

    public boolean isSameValueTypeAs(Value value) {
        return this.getClass() == value.getClass();
    }

    public final long hashCode64() {
        HashFunction xxh64 = HashFunction.incrementalXXH64();
        long seed = 1L;
        return xxh64.finalise(this.updateHash(xxh64, xxh64.initialise(seed)));
    }

    public abstract long updateHash(HashFunction var1, long var2);

    public static Map<String, String> parseStringMap(CharSequence text) {
        int end;
        Matcher mapMatcher = MAP_PATTERN.matcher(text);
        if (!mapMatcher.find() || mapMatcher.groupCount() != 1) {
            throw InvalidArgumentException.parseMapValue((String)String.valueOf(text));
        }
        String mapContents = mapMatcher.group(1);
        if (mapContents.isEmpty()) {
            throw InvalidArgumentException.parseMapValue((String)String.valueOf(text));
        }
        HashMap<String, String> data = new HashMap<String, String>();
        int length = mapContents.length();
        int i = 0;
        while (i < length && (end = mapContents.indexOf(58, i)) != -1) {
            String key = mapContents.substring(i, end).trim();
            Value.checkParseState(text, i, (i = end + 1) < length);
            while (i < length && Character.isWhitespace(mapContents.charAt(i))) {
                ++i;
            }
            char firstChar = mapContents.charAt(i);
            if (firstChar == '\'' || firstChar == '\"') {
                end = mapContents.indexOf(firstChar, ++i);
            } else {
                end = mapContents.indexOf(44, i);
                end = end == -1 ? mapContents.length() : end;
                Value.checkParseState(text, i, i != end);
                while (Character.isWhitespace(mapContents.charAt(end - 1))) {
                    --end;
                }
            }
            Value.checkParseState(text, i, end != -1);
            String value = mapContents.substring(i, end);
            if (data.containsKey(key)) {
                throw InvalidArgumentException.duplicateField((String)key);
            }
            data.put(key, value);
            for (i = end + 1; i < length && (Character.isWhitespace(mapContents.charAt(i)) || mapContents.charAt(i) == ','); ++i) {
            }
        }
        return data;
    }

    private static void checkParseState(CharSequence text, int i, boolean condition) {
        if (!condition) {
            throw new InvalidArgumentException(String.format("Was expecting key:value, key:'value' or key:\"value\" pairs in %s. Error near index %d", text, i));
        }
    }
}

