/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Comparator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Comparison;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValueGroup;

public abstract class VirtualPathValue
extends VirtualValue {
    public abstract long startNodeId();

    public abstract long endNodeId();

    public abstract long[] nodeIds();

    public abstract long[] relationshipIds();

    public abstract ListValue relationshipsAsList();

    public abstract int size();

    public abstract ListValue asList();

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.PATH;
    }

    @Override
    public int unsafeCompareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        VirtualPathValue otherPath = (VirtualPathValue)other;
        int x = Long.compare(this.startNodeId(), otherPath.startNodeId());
        if (x == 0) {
            int size = this.size();
            int otherSize = otherPath.size();
            int length = Math.min(size, otherSize);
            for (int i = 0; x == 0 && i < length; ++i) {
                x = Long.compare(this.relationshipId(i), otherPath.relationshipId(i));
            }
            if (x == 0) {
                x = Integer.compare(size, otherSize);
            }
        }
        return x;
    }

    @Override
    public Comparison unsafeTernaryCompareTo(VirtualValue other, TernaryComparator<AnyValue> comparator) {
        return Comparison.from(this.unsafeCompareTo(other, comparator));
    }

    @Override
    public boolean equals(VirtualValue other) {
        if (!(other instanceof VirtualPathValue)) {
            return false;
        }
        VirtualPathValue that = (VirtualPathValue)other;
        return this.size() == that.size() && this.startNodeId() == that.startNodeId() && this.relationshipIdsEquals(that);
    }

    @Override
    protected int computeHashToMemoize() {
        int result = Long.hashCode(this.startNodeId());
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            result += 31 * (result + Long.hashCode(this.relationshipId(i)));
        }
        return result;
    }

    private boolean relationshipIdsEquals(VirtualPathValue other) {
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            if (this.relationshipId(i) == other.relationshipId(i)) continue;
            return false;
        }
        return true;
    }

    public abstract long relationshipId(int var1);

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapPath(this);
    }

    @Override
    public String getTypeName() {
        return "Path";
    }
}

